<?php

namespace App\Helpers;

use Exception;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Config;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Carbon;
use App\Models\Category;
use App\Models\SubCategory;
use App\Models\Brand;
use App\Models\Item;
use App\Models\ItemVariant;
use App\Models\Cart;
use App\Models\CoachingCenter;
use App\Models\Pages;
use App\Models\SportsClinic;
use App\Models\Agent;
use App\Models\BatStringing;
use App\Models\Trainer;

class CommonHelper
{
  /**
   * To generate unique id for user
   *
   * @author RAHUL PA
   * 
   * @return integer/false
   */
  public function generateUniqueId()
  {
    return strtoupper(uniqid());
  }

  /**
   * generate random string and encrypt it. 
   *
   * @return string
   */
  public static function generatePassword()
  {
    return Hash::make(Str::random(35));
  }

  /**
   * generate remeber token with email. 
   *
   * @return string
   */
  public static function generateRememberToken($email)
  {
    return Hash::make($email);
  }

  public function generateSKU()
  {
    return 'SKU-' . strtoupper(Str::random(4));
  }

  /**
   * 
   * 
   */
  public function generateOneTimePassword($length = 4)
  {
    $result = '';
    for ($i = 0; $i < $length; $i++) {
      $result .= mt_rand(1, 9);
    }
    return $result;
  }

  /**
   * 
   * 
   */
  public function generateInvoiceNumber($id)
  {
    return 'Z-BS' . date('m') . '' . date('d') . '-' . $id;
  }

  public function generateBatStringingNumber()
  {
    $last_id = BatStringing::latest()->value('id');
    if ($last_id === null) {
     $order_number = 1;
    } else {
      $order_number = $last_id + 1;
    }
    return 'BSQBR-' . $order_number;
  }


  /**
   * 
   * @author RAHUL PA
   * 
   */
  public function generateUpiOrderId()
  {
    return 'upi_order_id_' . Carbon::now()->format('YmdHisu');
  }
  /**
   * 
   * @author RAHUL PA
   * 
   */
  public function itemImageUpload($content, $unique_code, $path)
  {
    $file           = base64_decode(substr($content, strpos($content, ',') + 1));
    $extension      = explode('/', explode(':', substr($content, 0, strpos($content, ';')))[1])[1];
    // .jpg .png .jpeg
    $image_name     = $unique_code . '_' . Carbon::now()->format('YmdHisu') . '.' . $extension;
    // create file

    $path           = $path . '/' . $image_name;
    Storage::disk('images')->put($path, $file);
    return '/images/' . $path;
  }

  /**
   * @author SOORYA
   * 
   */
  public function getCategorySlug($title)
  {
    $i              = 1;
    $slug_approved  = false;
    $slug   = $base_slug = Str::slug($title, '-');
    while ($slug_approved == false) {
      $check_slug   = (new Category())->getSameSlugExist($slug);
      if ($check_slug) {
        $slug_approved  = false;
        $slug           = $base_slug . '' . $i;
      } else {
        $slug_approved  = true;
      }
      $i++;
    }
    return $slug;
  }

  /**
   * @author SOORYA
   * 
   */
  public function getSubCategorySlug($title)
  {
    $i              = 1;
    $slug   = $base_slug = Str::slug($title, '-');
    while ($slug_approved == false) {
      $check_slug   = (new SubCategory())->getSameSlugExist($slug);
      if ($check_slug) {
        $slug_approved  = false;
        $slug           = $base_slug . '' . $i;
      } else {
        $slug_approved  = true;
      }
      $i++;
    }
    return $slug;
  }

  /**
   * @author SOORYA
   * 
   */
  public function getBrandSlug($title)
  {
    $i              = 1;
    $slug_approved  = false;
    $slug   = $base_slug = Str::slug($title, '-');
    while ($slug_approved == false) {
      $check_slug   = (new Brand())->getSameSlugExist($slug);
      if ($check_slug) {
        $slug_approved  = false;
        $slug           = $base_slug . '' . $i;
      } else {
        $slug_approved  = true;
      }
      $i++;
    }
    return $slug;
  }

  /**
   * @author SOORYA
   * 
   */
  public function getItemSlug($title)
  {
    $i              = 1;
    $slug_approved  = false;
    $slug   = $base_slug = Str::slug($title, '-');
    while ($slug_approved == false) {
      $check_slug   = (new Item())->getSameSlugExist($slug);
      if ($check_slug) {
        $slug_approved  = false;
        $slug           = $base_slug . '' . $i;
      } else {
        $slug_approved  = true;
      }
      $i++;
    }
    return $slug;
  }

  public function getPageSlug($title)
  {
    $i              = 1;
    $slug_approved  = false;
    $slug   = $base_slug = Str::slug($title, '-');
    while ($slug_approved == false) {
      $check_slug   = (new Pages())->getSameSlugExist($slug);
      if ($check_slug) {
        $slug_approved  = false;
        $slug           = $base_slug . '' . $i;
      } else {
        $slug_approved  = true;
      }
      $i++;
    }
    return $slug;
  }

  /**
   * @author SOORYA
   * 
   */
  public function getCoachingCenterSlug($title)
  {
    $i              = 1;
    $slug_approved  = false;
    $slug   = $base_slug = Str::slug($title, '-');
    while ($slug_approved == false) {
      $check_slug   = (new CoachingCenter())->getSameSlugExist($slug);
      if ($check_slug) {
        $slug_approved  = false;
        $slug           = $base_slug . '' . $i;
      } else {
        $slug_approved  = true;
      }
      $i++;
    }
    return $slug;
  }

  /**
   * @author SOORYA
   * 
   */
  public function getSportsClinicSlug($title)
  {
    $i              = 1;
    $slug_approved  = false;
    $slug   = $base_slug = Str::slug($title, '-');
    while ($slug_approved == false) {
      $check_slug   = (new SportsClinic())->getSameSlugExist($slug);
      if ($check_slug) {
        $slug_approved  = false;
        $slug           = $base_slug . '' . $i;
      } else {
        $slug_approved  = true;
      }
      $i++;
    }
    return $slug;
  }

  /**
   * @author SOORYA
   * 
   */
  public function getAgentSlug($title)
  {
    $i              = 1;
    $slug_approved  = false;
    $slug   = $base_slug = Str::slug($title, '-');
    while ($slug_approved == false) {
      $check_slug   = (new Agent())->getSameSlugExist($slug);
      if ($check_slug) {
        $slug_approved  = false;
        $slug           = $base_slug . '' . $i;
      } else {
        $slug_approved  = true;
      }
      $i++;
    }
    return $slug;
  }

  /**
   * @author SOORYA
   * 
   */
  public function getTrainerSlug($title)
  {
    $i              = 1;
    $slug_approved  = false;
    $slug   = $base_slug = Str::slug($title, '-');
    while ($slug_approved == false) {
      $check_slug   = (new Trainer())->getSameSlugExist($slug);
      if ($check_slug) {
        $slug_approved  = false;
        $slug           = $base_slug . '' . $i;
      } else {
        $slug_approved  = true;
      }
      $i++;
    }
    return $slug;
  }


  /**
   * 
   * update item quantity
   * 
   */
  public function updateItemStockQuantity($item_id, $variant_id, $quantity)
  {
    $item   = (new Item())->getSingleItem($item_id);
    if ($variant_id == $item->default_variant_id) {
      if ($item->stock_quantity > 0) {
        $stock_quantity   = $item->stock_quantity - $quantity;
        if ($stock_quantity == 0) {
          $stock_status = 0;
        } else {
          $stock_status = 1;
        }
        $stock_data       = [
          "stock_status"    => $stock_status,
          "stock_quantity"  => $stock_quantity,
        ];
        (new Item())->updateItem($item_id, $stock_data);
      }
    }
    $item_variant   = (new ItemVariant())->getSingleItemVariant($variant_id);
    if ($item_variant) {
      if ($item_variant->stock_quantity > 0) {
        $stock_quantity    = $item_variant->stock_quantity - $quantity;
        if ($stock_quantity == 0) {
          $stock_status = 0;
        } else {
          $stock_status = 1;
        }
        $stock_data       = [
          "stock_status"    => $stock_status,
          "stock_quantity"  => $stock_quantity,
        ];
        (new ItemVariant())->updateItem($variant_id, $stock_data);
      }
    }
    return true;
  }

  /**
   * 
   * @author PMS
   * check product quantity and cart quantity
   * 
   */
  public function checkProductQuantity($user_id)
  {
    $is_items_in_stock      = false;
    $carts                  = (new Cart())->getUserCart($user_id);
    if ($carts) {
      foreach ($carts as $cart) {

        $variant      = (new ItemVariant)->getVariant($cart->item_variant_id);
        if ($variant) {
          if ($variant->stock_quantity >= $cart->quantity && $variant->stock_status == 1) {
            $is_items_in_stock   = true;
          } else {
            $is_items_in_stock   = false;
          }
          $cart_stock_status    = $is_items_in_stock;
          $cart_stock_quantity  = $variant->stock_quantity;
          $cart_data           = [
            "stock_status"      => $cart_stock_status,
            "stock_quantity"    => $cart_stock_quantity,
          ];
          (new Cart())->updateCart($cart->id, $cart_data);
        }
      }
    }
    return $is_items_in_stock;
  }
  // ---------------------------------update cart quantity------------


  //data stucture
  public function tableDataStacture($data)
  {
    // $data = "[table] key,value##key,value";  // Your data
    $html = $data;
    try {
      if (strpos($data, '[table]') !== false) {
        $html = "";
        $data = str_replace('[table]', '', $data);
        $rows = explode('##', rtrim($data, '##'));
        $html .= '<table class="dyn_spf_list"><tbody>';

        foreach ($rows as $row) {
          $pairs = explode(',', $row);
          $html .= '<tr>';
          foreach ($pairs as $pair) {
            $parts = explode(',', $pair);
            $key = isset($parts[0]) ? $parts[0] : '';
            $value = isset($parts[1]) ? $parts[1] : '';
            $html .= '<td>' . $key . '</td>';
            $html .= '<td>' . $value . '</td>';
          }
          $html .= '</tr>';
        }

        $html .= '</tbody></table>';
        $html = str_replace('<td></td>', '', $html);
      }
      return $html;
    } catch (Exception $e) {
      return "wrong";
    }
  }

  public function getValidationMessage()
  {
    return  [

      /*
          |--------------------------------------------------------------------------
          | Validation Language Lines
          |--------------------------------------------------------------------------
          |
          | The following language lines contain the default error messages used by
          | the validator class. Some of these rules have multiple versions such
          | as the size rules. Feel free to tweak each of these messages here.
          |
          */

      'accepted'            => 'The :attribute must be accepted.',
      'active_url'          => 'The :attribute is not a valid URL.',
      'after'               => 'The :attribute must be a date after :date.',
      'after_or_equal'      => 'The :attribute must be a date after or equal to :date.',
      'alpha'               => 'The :attribute may only contain letters.',
      'alpha_dash'          => 'The :attribute may only contain letters, numbers, dashes and underscores.',
      'alpha_num'           => 'The :attribute may only contain letters and numbers.',
      'array'               => 'The :attribute must be an array.',
      'before'              => 'The :attribute must be a date before :date.',
      'before_or_equal'     => 'The :attribute must be a date before or equal to :date.',
      'between'             => [
        'numeric' => 'The :attribute must be between :min and :max.',
        'file' => 'The :attribute must be between :min and :max kilobytes.',
        'string' => 'The :attribute must be between :min and :max characters.',
        'array' => 'The :attribute must have between :min and :max items.',
      ],
      'boolean'             => 'The :attribute field must be true or false.',
      'confirmed'           => 'The :attribute confirmation does not match.',
      'date'                => 'The :attribute is not a valid date.',
      'date_equals'         => 'The :attribute must be a date equal to :date.',
      'date_format'         => 'The :attribute does not match the format :format.',
      'different'           => 'The :attribute and :other must be different.',
      'digits'              => 'The :attribute must be :digits digits.',
      'digits_between'      => 'The :attribute must be between :min and :max digits.',
      'dimensions'          => 'The :attribute has invalid image dimensions.',
      'distinct'            => 'The :attribute field has a duplicate value.',
      'email'               => 'The :attribute must be a valid email address.',
      'exists'              => 'The selected :attribute is invalid.',
      'file'                => 'The :attribute must be a file.',
      'filled'              => 'The :attribute field must have a value.',
      'gt'                  => [
        'numeric' => 'The :attribute must be greater than :value.',
        'file' => 'The :attribute must be greater than :value kilobytes.',
        'string' => 'The :attribute must be greater than :value characters.',
        'array' => 'The :attribute must have more than :value items.',
      ],
      'gte'                 => [
        'numeric' => 'The :attribute must be greater than or equal :value.',
        'file' => 'The :attribute must be greater than or equal :value kilobytes.',
        'string' => 'The :attribute must be greater than or equal :value characters.',
        'array' => 'The :attribute must have :value items or more.',
      ],
      'image'               => 'The :attribute must be an image.',
      'in'                  => 'The selected :attribute is invalid.',
      'in_array'            => 'The :attribute field does not exist in :other.',
      'integer'             => 'The :attribute must be an integer.',
      'ip'                  => 'The :attribute must be a valid IP address.',
      'ipv4'                => 'The :attribute must be a valid IPv4 address.',
      'ipv6'                => 'The :attribute must be a valid IPv6 address.',
      'json'                => 'The :attribute must be a valid JSON string.',
      'lt'                  => [
        'numeric' => 'The :attribute must be less than :value.',
        'file' => 'The :attribute must be less than :value kilobytes.',
        'string' => 'The :attribute must be less than :value characters.',
        'array' => 'The :attribute must have less than :value items.',
      ],
      'lte'                 => [
        'numeric' => 'The :attribute must be less than or equal :value.',
        'file' => 'The :attribute must be less than or equal :value kilobytes.',
        'string' => 'The :attribute must be less than or equal :value characters.',
        'array' => 'The :attribute must not have more than :value items.',
      ],
      'max'                 => [
        'numeric' => 'The :attribute may not be greater than :max.',
        'file' => 'The :attribute may not be greater than :max kilobytes.',
        'string' => 'The :attribute may not be greater than :max characters.',
        'array' => 'The :attribute may not have more than :max items.',
      ],
      'mimes'               => 'The :attribute must be a file of type: :values.',
      'mimetypes'           => 'The :attribute must be a file of type: :values.',
      'min'                 => [
        'numeric' => 'The :attribute must be at least :min.',
        'file' => 'The :attribute must be at least :min kilobytes.',
        'string' => 'The :attribute must be at least :min characters.',
        'array' => 'The :attribute must have at least :min items.',
      ],
      'not_in'              => 'The selected :attribute is invalid.',
      'not_regex'           => 'The :attribute format is invalid.',
      'numeric'             => 'The :attribute must be a number.',
      'present'             => 'The :attribute field must be present.',
      'regex'               => 'The :attribute format is invalid.',
      'required'            => 'The :attribute field is required.',
      'required_if'         => 'The :attribute field is required when :other is :value.',
      'required_unless'     => 'The :attribute field is required unless :other is in :values.',
      'required_with'       => 'The :attribute field is required when :values is present.',
      'required_with_all'     => 'The :attribute field is required when :values are present.',
      'required_without'     => 'The :attribute field is required when :values is not present.',
      'required_without_all' => 'The :attribute field is required when none of :values are present.',
      'same'                 => 'The :attribute and :other must match.',
      'size'                 => [
        'numeric' => 'The :attribute must be :size.',
        'file' => 'The :attribute must be :size kilobytes.',
        'string' => 'The :attribute must be :size characters.',
        'array' => 'The :attribute must contain :size items.',
      ],
      'string'              => 'The :attribute must be a string.',
      'timezone'            => 'The :attribute must be a valid zone.',
      'unique'              => 'The :attribute has already been taken.',
      'uploaded'            => 'The :attribute failed to upload.',
      'url'                 => 'The :attribute format is invalid.',
      'uuid'                => 'The :attribute must be a valid UUID.',

      /*
          |--------------------------------------------------------------------------
          | Custom Validation Language Lines
          |--------------------------------------------------------------------------
          |
          | Here you may specify custom validation messages for attributes using the
          | convention "attribute.rule" to name the lines. This makes it quick to
          | specify a specific custom language line for a given attribute rule.
          |
          */

      'custom' => [
        'manager.username' => [
          'unique'    => 'The username has already been taken',
        ],
        'manager.password' => [
          'max'       => 'The maximum length of email should be 50',
        ]
      ],

      /*
          |--------------------------------------------------------------------------
          | Custom Validation Attributes
          |--------------------------------------------------------------------------
          |
          | The following language lines are used to swap our attribute placeholder
          | with something more reader friendly such as "E-Mail Address" instead
          | of "email". This simply helps us make our message more expressive.
          |
          */

      'attributes' => [
        'manager.username' => 'username',
      ],

    ];
  }

  /**
   * get total price for order/subscription with cart price
   * 
   * @return total_price
   */
  public function getCartTotalPrice($start_date = null, $end_date = null, $week_days = [], $price = null)
  {
    $days_count     = 0;
    if (strtotime(date("Y-m-d", strtotime($end_date))) > strtotime(date("Y-m-d", strtotime($start_date)))) {
      for ($each_date  = strtotime($start_date); $each_date <= strtotime($end_date); $each_date = strtotime('+1 day', $each_date)) {
        if (in_array(date("w", $each_date), $week_days)) {
          $days_count++;
        }
      }
      $price  = ($days_count == 0) ? 0.00 : $price * $days_count;
    }
    return $price;
  }
}
