<?php

namespace App\Helpers;

// per_page
// sort_by
// sort_type
// from_date
// to_date
// key_word
// filter_by

class Filter
{
    public static function init($query, $params){

        $from = $params->from;
        $to = $params->to;
        $filter_by = $params->filter_by;
        $key_word = $params->key_word;
        $search_columns = $params->search_columns;
        $sort_by = $params->sort_by;
        $sort_type = $params->sort_type;

        return $query->when((!is_null($params->to) && !is_null($params->from)),
                                function($q) use($from, $to, $filter_by){
            $q->whereBetween($filter_by, [$from, $to]);
        })
       ->when((is_null($to) && !is_null($from)), function($q) use($from, $filter_by){
            $q->whereDate($filter_by, '>=', $from);
        })
        ->when((!is_null($key_word)), function($_query) use($key_word, $search_columns){
            $_query->where(function($q) use($key_word, $search_columns){
                if(is_null($search_columns)) return;
                foreach ($search_columns as $index => $column) {
                    if($index == 0){
                        $q->where($column, 'like', '%' . $key_word . '%');
                    }
                    else{
                        $q->orWhere($column, 'like', '%' . $key_word . '%');
                    }
                }
            });
        })
        ->when((!is_null($sort_by)), function($_query) use($sort_by, $sort_type){
            $_query->orderBy($sort_by, $sort_type);
        })->distinct();
    }

    public static function getFilters($request, $table = null){
        $input = $request->all();

        return (object) [
            'per_page' => isset($input['per_page']) ? $input['per_page'] : 10,
            'sort_by' => self::getColum(isset($input['sort_by']) ? $input['sort_by'] : 'id', $table),
            'sort_type' => isset($input['sort_type']) ? $input['sort_type'] : 'desc',
            'from' => isset($input['from_date']) ? $input['from_date'] : null,
            'to' => isset($input['to_date']) ? $input['to_date'] : null,
            'filter_by' => self::getColum(@$input['filter_by'], $table),
            'key_word' => isset($input['key_word']) ? $input['key_word'] : null,
        ];
    }

    public static function getColum($colum, $table = null){
        if(isset($colum)){
            if(!is_null($table)){
                return $table . '.' . $colum;
            }
            return $colum;
        }
        return null;
    }
}
