<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Http\Response;
use App\Models\Authors;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Storage;
use Validator;

class AdminAuthorController extends Controller
{

    /**
     * Http response data
     */
    private $data;

    /**
     * Http response code
     */
    private $code;

    /**
     * Response status
     */
    private $success;

    /**
     * Response message
     */
    private $message;

    /**
     * Init class attributes
     */
    public function __construct(Request $request)
    {
        $this->data     = new \stdClass();
        $this->code     = Response::HTTP_OK;
        $this->success  = true;
        $this->message  = '';
    }

    public function getAuthors()
    {
        return view('admin.authors.list');
    }

    public function getAuthorList(Request $request)
    {
        $result = (new Authors())->getAdminAuthorsList($request);
        $this->data  = [
            'results' =>  $result,
            'link' =>  (string) $result->links()
        ];
        return response()->json([
            'success'   => $this->success,
            'message'   => 'Author list successfully retrieved',
            'data'      => $this->data
        ], $this->code);
    }

    public function createAuthor()
    {
        return view('admin.authors.create');
    }

    public function saveAuthor(Request $request)
    {
        $validation = Validator::make($request->all(), [
            'name'         => 'required',
        ]);
        if (!$validation->passes()) {
            return response()->json([
                'success'   => false,
                'message'   => $validation->errors()->first(),
                'data'      => $this->data
            ], $this->code);
        }
        $inputs = [
            'name'       => $request->name,
            'bio'        => $request->bio
        ];
        $file       =  $request->file('image');
        if ($file) {
            $extension  = $file->extension();
            $file_name  = implode('_', [date('YmdHis'), Str::slug($request->name, '_')]);
            $path       = 'images/author/';
            Storage::disk('local')->putFileAs('public/' . $path, $file, $file_name . '.' . $extension);
            $inputs['image'] = '/storage/' . $path . $file_name . '.' . $extension;
        }
        (new Authors())->saveData($inputs);
        $request->session()->flash('message', 'Author successfully Created');
        $request->session()->flash('alert-class', 'alert-success');
        return redirect('/admin/authors');
    }

    public function deleteAuthor(Request $request)
    {
        (new Authors())->deleteAuthor($request->id);
        return response()->json([
            'success'   => $this->success,
            'message'   => 'Author  successfully deleted',
            'data'      => $this->data
        ], $this->code);
    }
    public function getAuthorData(Request $request)
    {
        $this->data  = ['author' => (new Authors())->getSingleAuthor($request->id)];
        return response()->json([
            'success'   => $this->success,
            'message'   => 'Banner Image successfully retrieved',
            'data'      => $this->data
        ], $this->code);
    }

    public function updateAuthor(Request $request)
    {
        $validation = Validator::make($request->all(), [
            'name'                => 'required',
        ]);
        if (!$validation->passes()) {
            return response()->json([
                'success'   => false,
                'message'   => $validation->errors()->first(),
                'data'      => $this->data
            ], $this->code);
        }
        $data = [
            'name'           => $request->name,
            'bio'            => $request->bio,
        ];

        if ($request->image) {
            $file       =  $request->file('image');
            $extension  = $file->extension();
            $file_name  = implode('_', [date('YmdHis'),Str::slug($request->name, '_')]);
            $path       = 'images/author/';
            Storage::disk('local')->putFileAs('public/' . $path, $file, $file_name . '.' . $extension);
            $data['image']  = '/storage/' . $path . $file_name . '.' . $extension;
        }
        (new Authors())->updateAuthor($request->id, $data);
        return response()->json([
            'success'   => $this->success,
            'message'   => 'Author data successfully updated',
            'data'      => $this->data
        ], $this->code);
    }
}
