<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Validator;
use \Exception;
use App\Helpers\CommonHelper;
use App\Models\Authors;
use App\Models\Category;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Storage;
use Auth;

class AdminCategoryController extends Controller
{
    /**
     * Http response data
     */
    private $data;

    /**
     * Http response code
     */
    private $code;

    /**
     * Response status
     */
    private $success;

    /**
     * Response message
     */
    private $message;

    /**
     * Init class attributes
     */
    public function __construct(Request $request)
    {
        $this->data     = new \stdClass();
        $this->code     = Response::HTTP_OK;
        $this->success  = true;
        $this->message  = '';
    }



    public function getCategoryIndex()
    {

        return view('admin.category.list');
    }




     /**
     * get all user category list
     * @author  SOORYA
    */
    public function getCategoryList(Request $request)
    {
        $result = (new Category())->getAdminCategoryList($request) ;
        $this->data  = [    'results' =>  $result ,
                            'link' =>  (string) $result->links() 
                        ];
        return response()->json([
                'success'   => $this->success,
                'message'   => 'Category list successfully retrieved',
                'data'      => $this->data
        ], $this->code);
    }

    public function getAllCategories(Request $request)
    {
        $this->data  = ['categories' =>  (new Category())->getAdminCategories($request) ];
        return response()->json([
                'success'   => $this->success,
                'message'   => 'Category list successfully retrieved',
                'data'      => $this->data
        ], $this->code);
    }

     /**
     * getSingleCategory
     * @author  SOORYA
    */
    public function getSingleCategory(Request $request)
    {
        $this->data  = ['category' =>  (new Category())->getSingleCategory($request->id) ];
        return response()->json([
                'success'   => $this->success,
                'message'   => 'Category list successfully retrieved',
                'data'      => $this->data
        ], $this->code);
    }
    /**
     * getCategoriesByStore
     * @author  PMS
    */
    public function getCategories(Request $request)
    {
        $this->data  = ['categories' =>   (new Category())->getCategories($request)  ];
        return response()->json([
                'success'   => $this->success,
                'message'   => 'Category list successfully retrieved',
                'data'      => $this->data
        ], $this->code);
    }

         /**
     * updateCateGory
     * @author  SOORYA
    */

    public function edit(Request $request)
    {
        $parent_categories = (new Category())->getMainCategory();
        $category = Category::find(base64_decode($request->id));
        return view('admin.category.edit',['category' => $category,'parent_categories' => $parent_categories]);
    }

    public function update(Request $request)
    {
         $validation = Validator::make($request->all(), [
             
             'name'         => 'required',
             'is_active'    => 'required'
         ]) ;
        if(!$validation->passes())
        {
          return response()->json([
                'success'   => false,
                'message'   =>  $validation->errors()->first() ,
                'data'      => $this->data
            ], $this->code);
        }

        $input = [
            'parent_id'     => $request->parent_id,
            'name'          => $request->name,
            'is_active'     =>  $request->is_active,
            'slug'          => Str::slug($request->name)
        ]; 

        if($request->file('logo'))
        {
            $file               =  $request->file('logo');
            $extension          = $file->extension();
            $file_name          = implode('_', [
                                    date('YmdHis'),
                                    Str::slug($request->name,'_logo')
                                ]);
    
            $path               = 'images/category/';
            Storage::disk('local')->putFileAs('public/'.$path, $file,$file_name .'.'. $extension);
            $input['logo']      = '/storage/'.$path. $file_name .'.'. $extension;

        }

        if($request->file('banner'))
        {
            $file               = $request->file('banner');
            $extension          = $file->extension();
            $file_name          = implode('_', [
                                    date('YmdHis'),
                                    Str::slug($request->name,'_banner')
                                ]);
    
            $path               = 'images/category/';
            Storage::disk('local')->putFileAs('public/'.$path, $file,$file_name .'.'. $extension);
            $input['banner']    = '/storage/'.$path. $file_name .'.'. $extension;
        }
 
        (new Category())->updateCategory($request->id, $input );


        return redirect('/admin/categories');

    }

        /**
     * updateCateGory
     * @author  SOORYA
    */

    public function create(Request $request)
    {
        $parent_categories = (new Category())->getMainCategory();
        return view('admin.category.create',compact('parent_categories'));
    }

        /**
     * updateCateGory
     * @author  SOORYA
    */

    public function createCategory(Request $request)
    {
         $validation = Validator::make($request->all(), [
             'name'         => 'required',
             'logo'         => 'required|image|mimes:jpeg,png,jpg',
             'banner'       => 'required|image|mimes:jpeg,png,jpg',
             'is_active'    => 'required'
         ]) ;
        if(!$validation->passes())
        {
          return response()->json([
                'success'   => false,
                'message'   => $validation->errors()->first() ,
                'data'      => $this->data
            ], $this->code);
        }
        if($request->file('logo'))
        {
            $file      =  $request->file('logo');
            $extension = $file->extension();
            $file_name = implode('_', [
                    date('YmdHis'),
                    Str::slug($request->name,'_logo')
                ]);
    
            $path      = 'images/category/';
            Storage::disk('local')->putFileAs('public/'.$path, $file,$file_name .'.'. $extension);
            $logo      = '/storage/'.$path. $file_name .'.'. $extension;

        }

        if($request->file('banner'))
        {
            $file      =  $request->file('banner');
            $extension = $file->extension();
            $file_name = implode('_', [
                    date('YmdHis'),
                    Str::slug($request->name,'_banner')
                ]);
    
            $path = 'images/category/';
            Storage::disk('local')->putFileAs('public/'.$path, $file,$file_name .'.'. $extension);
            $banner    = '/storage/'.$path. $file_name .'.'. $extension;
        }

        (new Category())->createCategory([
            'name'      => $request->name,
            'parent_id' => $request->parent_id,
            'logo'      => $logo,
            'banner'    => $banner,
            'is_active' =>  $request->is_active,
        ]);

        $request->session()->flash('message', 'Category successfully Created'); 
        $request->session()->flash('alert-class', 'alert-success'); 
        return redirect('/admin/categories');

    }

    /**
     * 
     * 
     */
    public function homeStatus(Request $request)
    {
        (new Category())->changeStatus($request->id);
        return response()->json([
                'success'   => $this->success,
                'message'   => 'Popular Status Updated',
                'data'      => $this->data
        ], $this->code);
    } 
}
