<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Validator;
use \Exception;
use App\Models\Settings;
use App\Models\DeliveryBoySlotConfiguration;
use App\Models\DeliveryBoyPayment;
use App\Helpers\CommonHelper;
use App\Models\Folder;
use App\Models\Pincode;
use App\Store;
use App\Models\City;
use App\Models\State;
use Illuminate\Support\Facades\DB;

class AdminFolderController extends Controller
{
    /**
     * Http response data
     */
    private $data;

    /**
     * Http response code
     */
    private $code;

    /**
     * Response status
     */
    private $success;

    /**
     * Response message
     */
    private $message;

    /**
     * Init class attributes
     */
    public function __construct(Request $request)
    {
        $this->data     = new \stdClass();
        $this->code     = Response::HTTP_OK;
        $this->success  = true;
        $this->message  = '';
    }


     /**
     * get all user category list
     * @author  RAHUL
    */
    public function getFolderList(Request $request)
    {
        $result = (new Folder())->getAdminFolderList($request);
        $this->data  = [    'results' =>  $result ,
                            'link' =>  (string) $result->links() 
                        ];
        return response()->json([
                'success'   => $this->success,
                'message'   => 'Folder list successfully retrieved',
                'data'      => $this->data
        ], $this->code);
    }

    public function settingsList(Request $request)
    {
        $result = (new Settings())->getSettingList($request);
        $this->data  = [    'results' =>  $result ,
                            'link' =>  (string) $result->links() 
                        ];
        return response()->json([
                'success'   => $this->success,
                'message'   => 'Settings successfully retrieved',
                'data'      => $this->data
        ], $this->code);
    }

   
    public function getStoreFolderIndex(Request $request, $uid)
    {
        $this->data = ['store' => (new Store())->getStoreByUid($uid) ];
        return view('admin.media.store-folder', $this->data);
    }

    public function getSetting(Request $request)
    {
        $this->data  = ['setting' =>  (new Settings())->getSettingsById($request->id) ];
        return response()->json([
                'success'   => $this->success,
                'message'   => 'Setting successfully retrieved',
                'data'      => $this->data
        ], $this->code);
    }

    public function updateSetting(Request $request)
    {
        (new Settings())->updateSettings($request);
        return response()->json([
                'success'   => $this->success,
                'message'   => 'Setting successfully updated',
                'data'      => $this->data
        ], $this->code);
    }

    /**
     * 
     * @author  RAHUL
    */
    public function createFolder(Request $request)
    {
        (new Folder())->createAdminFolder(['name'=>$request->name]);
        return response()->json([
                'success'   => $this->success,
                'message'   => 'Folder successfully created',
                'data'      => $this->data
        ], $this->code);
    }

    /**
     * 
     * @author  RAHUL
    */
    public function createStoreFolder(Request $request)
    {
        (new Folder())->createAdminFolder(['name'=>$request->name , 'store_id' => $request->store_id ]);
        return response()->json([
                'success'   => $this->success,
                'message'   => 'Folder successfully created',
                'data'      => $this->data
        ], $this->code);
    }



    /**
     * 
     * @author  RAHUL
    */ 
    public function updateFolder(Request $request)
    {
        (new Folder())->updatedFolder($request);
        return response()->json([
                'success'   => $this->success,
                'message'   => 'Folder successfully updated',
                'data'      => $this->data
        ], $this->code);
    }

    public function deleteFolderList(Request $request)
    {
        (new Folder())->deleteFolder($request->id);
        return response()->json([
                'success'   => $this->success,
                'message'   => 'Folder successfully deleted',
                'data'      => $this->data
        ], $this->code);
    }

    /**
     * get all user category list
     * @author  RAHUL
    */
    public function getSingleFolder(Request $request)
    {
        $this->data  = ['folder' =>  (new Folder())->getSingleFolder($request->id) ];
        return response()->json([
                'success'   => $this->success,
                'message'   => 'Folder successfully retrieved',
                'data'      => $this->data
        ], $this->code);
    }
    
    public function deliveryBoyConfigurationList(Request $request)
    {
        $result = (new DeliveryBoySlotConfiguration())->getdeliveryBoyConfigurationList($request);
        $this->data  = [    'results' =>  $result ,
                            'link' =>  (string) $result->links() 
                        ];
        return response()->json([
                'success'   => $this->success,
                'message'   => 'Delivery Boy Configuration successfully retrieved',
                'data'      => $this->data
        ], $this->code);
    }

    public function getDeliveryBoyConfiguration(Request $request)
    {
        $this->data  = ['configuration' =>  (new DeliveryBoySlotConfiguration())->getDeliveryBoyConfigurationsById($request->id) ];
        return response()->json([
                'success'   => $this->success,
                'message'   => 'Delivery Boy Configuration successfully retrieved',
                'data'      => $this->data
        ], $this->code);
    }

    public function updateDeliveryBoyConfiguration(Request $request)
    {
        (new DeliveryBoySlotConfiguration())->updateDeliveryBoyConfigurations($request);
        return response()->json([
                'success'   => $this->success,
                'message'   => 'Delivery Boy Configuration successfully updated',
                'data'      => $this->data
        ], $this->code);
    }

    public function partTimeDeliveryBoyConfigurationList(Request $request)
    {
        $result = (new DeliveryBoyPayment())->getpartTimeDeliveryBoyConfigurationList($request);
        $this->data  = [    'results' =>  $result ,
                            'link' =>  (string) $result->links() 
                        ];
        return response()->json([
                'success'   => $this->success,
                'message'   => 'Delivery Boy Configuration successfully retrieved',
                'data'      => $this->data
        ], $this->code);
    }
    
    public function getPartTimeDeliveryBoyConfiguration(Request $request)
    {
        $this->data  = ['payment' =>  (new DeliveryBoyPayment())->getPartTimeDeliveryBoyConfigurationsById($request->id) ];
        return response()->json([
                'success'   => $this->success,
                'message'   => 'Delivery Boy Configuration successfully retrieved',
                'data'      => $this->data
        ], $this->code);
    }

    public function updatePartTimeDeliveryBoyConfiguration(Request $request)
    {
        (new DeliveryBoyPayment())->updatePartTimeDeliveryBoyConfigurations($request);
        return response()->json([
                'success'   => $this->success,
                'message'   => 'Delivery Boy Configuration successfully updated',
                'data'      => $this->data
        ], $this->code);
    }

    public function getPincodeIndex(Request $request)
    {
        $this->data = [
                        'cities' => (new City())->getAllCities(),
                        'states' => (new State())->getAllStates() 
                      ];

        return view('admin.pincode.list', $this->data);
    }

    /**
     * @param  Request
     * @return json
     */
    public function createPincode(Request $request)
    {

        (new Pincode())->createPincode($request);
        return response()->json([
            'success'   => $this->success,
            'message'   => 'Pincode successfully created',
            'data'      => $this->data
        ], $this->code);
    }

    /**
     * 
     * @author  SOORYA
    */ 
    public function updatePincode(Request $request)
    {
        (new Pincode())->updatePincode($request);
        return response()->json([
                'success'   => $this->success,
                'message'   => 'Pincode successfully updated',
                'data'      => $this->data
        ], $this->code);
    }


    /**
     * 
     * @author  SOORYA
    */
    public function getSinglePincode(Request $request)
    {
        $this->data = [ 'pincode' =>(new Pincode())->getPincodeById($request->id)];
        return response()->json([
                'success'   => $this->success,
                'message'   => 'Pincode successfully fetched',
                'data'      => $this->data
        ], $this->code);
    }

    /**
     * get all user pincode list
     * @author  SOORYA
    */
    public function getPincodeList(Request $request)
    {
        $result         =  (new Pincode())->getPincodeList($request);
        $this->data     =  [    'results' =>  $result ,
                                'link' =>  (string) $result->links() 
                            ];
        return response()->json([
                'success'   => $this->success,
                'message'   => 'Store successfully retrieved',
                'data'      => $this->data
        ], $this->code);
    }

    public function getLocation(Request $request)
    {
        $pincode    =    Pincode::with('city','state')->where('pincode',$request->pincode)->get();
        $this->data = $pincode;
        return response()->json([
            'success'   => $this->success,
            'message'   => 'Location successfully retrieved',
            'data'      => $this->data
        ], $this->code);

    }

    
    /**
     * 
     * 
     */
    public function getCreateFolderRules()
    {
        return [           
            'folder'      => 'required|unique:sizes,name,NULL,id,deleted_at,NULL',
           
        ];
    }

   
}
