<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Validator;
use \Exception;
use App\Helpers\CommonHelper;
use App\Models\Banner;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Storage;
use Auth;


class BannerController extends Controller
{
    /**
     * Http response data
     */
    private $data;

    /**
     * Http response code
     */
    private $code;

    /**
     * Response status
     */
    private $success;

    /**
     * Response message
     */
    private $message;

    /**
     * Init class attributes
     */
    public function __construct(Request $request)
    {
        $this->data     = new \stdClass();
        $this->code     = Response::HTTP_OK;
        $this->success  = true;
        $this->message  = '';
    }

    /**
     * get all user category list
     * @author  RAHUL
     */

    public function list()
    {
        $this->data  =  [
            'categories'    =>  [],
        ];
        return view('admin.banners.list', $this->data);
    }



    public function getBannerImage(Request $request)
    {
        $this->data  = ['image' => (new Banner())->getBannerImageById($request->id)];
        return response()->json([
            'success'   => $this->success,
            'message'   => 'Banner Image successfully retrieved',
            'data'      => $this->data
        ], $this->code);
    }


    public function updateBannerImage(Request $request)
    {
        $validation = Validator::make($request->all(), [
            'name'                => 'required',
        ]);
        if (!$validation->passes()) {
            return response()->json([
                'success'   => false,
                'message'   => $validation->errors()->first(),
                'data'      => $this->data
            ], $this->code);
        }
        $data = [

            'name'                       => $request->name,
            'priority'                   => $request->priority,
            'link'                       => $request->link
        ];

        if ($request->image) {
            $file =  $request->file('image');
            $extension = $file->extension();
            $file_name = implode('_', [
                date('YmdHis'),
                Str::slug($request->name, '_')
            ]);

            $path = 'images/banner/';

            Storage::disk('local')->putFileAs('public/' . $path, $file, $file_name . '.' . $extension);
            $data['image']  = '/storage/' . $path . $file_name . '.' . $extension;
        }

        if ($request->mobile_banner) {
            $mobile_banner_file         =  $request->file('mobile_banner');
            $mobile_banner_extension    = $mobile_banner_file->extension();
            $mobile_banner_file_name    = implode('_', [date('YmdHis'),Str::slug($request->name, '_')]);
            $path                       = 'images/banner/';
            Storage::disk('local')->putFileAs('public/' . $path, $mobile_banner_file, $mobile_banner_file_name . '.' . $mobile_banner_extension);
            $data['mobile_banner']      = '/storage/' . $path . $mobile_banner_file_name . '.' . $mobile_banner_extension;
        }
        (new Banner())->updateBannerImage($request->id, $data);
        return response()->json([
            'success'   => $this->success,
            'message'   => 'Banner Image successfully updated',
            'data'      => $this->data
        ], $this->code);
    }


    public function deleteBannerImage(Request $request)
    {
        (new Banner())->bannerDelete($request->id);
        return response()->json([
            'success'   => $this->success,
            'message'   => 'Banner  successfully deleted',
            'data'      => $this->data
        ], $this->code);
    }

    /**
     * get all user category list
     * @author  RAHUL
     */
    public function getAdminBannerImageList(Request $request)
    {
        $result = (new Banner())->getBannerImageList($request);
        $this->data  = [
            'results' =>  $result,
            'link' =>  (string) $result->links()
        ];
        return response()->json([
            'success'   => $this->success,
            'message'   => 'Banner list successfully retrieved',
            'data'      => $this->data
        ], $this->code);
    }


    /**
     * updateCateGory
     * @author  RAHUL
     */
    public function createAdminBannerImage(Request $request)
    {
        $validation = Validator::make($request->all(), [
            'name'                => 'required',
            'image'               => 'required|image|mimes:jpeg,png,jpg|max:1048',
            'mobile_banner'       => 'required|image|mimes:jpeg,png,jpg|max:1048'
        ]);
        if (!$validation->passes()) {
            return response()->json([
                'success'   => false,
                'message'   => $validation->errors()->first(),
                'data'      => $this->data
            ], $this->code);
        }

        $file       =  $request->file('image');
        $extension  = $file->extension();
        $file_name  = implode('_', [date('YmdHis'), Str::slug($request->name, '_')]);
        $path       = 'images/banner/';
        Storage::disk('local')->putFileAs('public/' . $path, $file, $file_name . '.' . $extension);

        $mobile_banner_file       =  $request->file('mobile_banner');
        $mobile_bannner_extension  = $mobile_banner_file->extension();
        $mobile_banner_file_name  = implode('_mobile_banner_', [date('YmdHis'), Str::slug($request->name, '_')]);
        $path       = 'images/banner/';
        Storage::disk('local')->putFileAs('public/' . $path, $mobile_banner_file, $mobile_banner_file_name . '.' . $mobile_bannner_extension);
        (new Banner())->createBanner([

            'name'                  => $request->name,
            'name'                  => $request->name,
            'priority'              => $request->priority,
            'link'                  => $request->link,
            'image'                 => '/storage/' . $path . $file_name . '.' . $extension,
            'mobile_banner'         => '/storage/' . $path . $mobile_banner_file_name . '.' . $mobile_bannner_extension,
        ]);

        return response()->json([
            'success'   => $this->success,
            'message'   => 'Banner  successfully created',
            'data'      => $this->data
        ], $this->code);
    }
}
