<?php

namespace App\Http\Controllers;

use App\Helpers\CommonHelper;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\Redirect;
use Maatwebsite\Excel\Facades\Excel;
use App\Imports\ProductList;
use App\Models\Authors;
use App\Models\Category;
use App\Models\GoogleSheet;
use App\Models\Item;
use App\Models\itemImage;
use App\Models\productType;
use Illuminate\Support\Str;
use Auth;
use Carbon\Carbon;
use Validator;
use DB;
use Illuminate\Support\Facades\Storage;

class BulkUploadController extends Controller
{
    /**
     * Http response data
     */
    private $data;

    /**
     * Http response code
     */
    private $code;

    /**
     * Response status
     */
    private $success;

    /**
     * Response message
     */
    private $message;

    /**
     * Init class attributes
     */
    public function __construct(Request $request)
    {
        $this->data     = new \stdClass();
        $this->code     = Response::HTTP_OK;
        $this->success  = true;
        $this->message  = '';
    }

    public function checkExcelFiled($excel_data_header)
    {

        $header_list     = ["SKU", "Title", "Description", "Mrp", "Price", "Image", "Gallery1", "Gallery2", "Gallery3", "Gallery4", "Feature1", "Feature2", "Feature3", "Feature4", "Feature5", "Product Specification"];
        foreach ($header_list as $key => $value) {
            if ($header_list[$key] != $excel_data_header[$key]) {
                return "failed";
            }
        }
        return "success";
    }

    public function processBulkUpload(Request $request)
    {



        $this->validate($request, [
            "product_list"  => 'required|mimes:xls,xlsx,csv'
        ]);


        if (empty($request->file('product_list'))) {
            return back()->with('success', 'No file selected');
        } else {
            $products   = [];
            $rows = Excel::toArray(new ProductList, $request->file('product_list'));
            if (sizeof($rows[0]) > 1) {
                $excel_data = $rows[0];
                // dd($excel_data);
                if ($this->checkExcelFiled($excel_data[0]) == "success") {
                    unset($excel_data[0]);

                    foreach ($excel_data as $data) {
                        if ($data[0] && $data[1] != null) {


                            $products[] = [
                                'sku'                    => $data[0],
                                'title'                  => $data[1],
                                'description'            => $data[2],
                                'mrp'                    => $data[3],
                                'price'                  => $data[4],
                                'image'                  => $data[5],
                                'gallery1'               => $data[6],
                                'gallery2'               => $data[7],
                                'gallery3'               => $data[8],
                                'gallery4'               => $data[9],
                                'feature1'               => $data[10],
                                'feature2'               => $data[11],
                                'feature3'               => $data[12],
                                'feature4'               => $data[13],
                                'feature5'               => $data[14],
                                'product_specification'  => $data[15],
                            ];
                        }
                    }
                } else {
                    return Redirect::back()->with(['message' => 'Wrong columns in excel. Please check', 'message-class' => 'alert-danger']);
                }
            } else {
                return Redirect::back()->with(['message' => 'Minimum 1 row data required. Please check', 'message-class' => 'alert-danger']);
            }
            return view('admin.products.bulk-upload', ['products' => $products]);
        }
    }


    public function imageUploadFetchUrl($url, $name)
    {
        if ($url) {
            $extension = pathinfo($url, PATHINFO_EXTENSION);
            $file_name = strtolower(str_replace(' ', '_', $name)) . '_' . time();
            $path = 'images/product/';
            $image_content = file_get_contents($url);
            Storage::disk('local')->put('public/' . $path . $file_name . '.' . $extension, $image_content);
            return '/storage/' . $path . $file_name . '.' . $extension;
        } else {
            return "";
        }
    }

    public function saveBulkUpload(Request $request)
    {

        $validator = Validator::make(
            $request->all(),
            [
                // 'sku'                       => 'required|unique:items,sku,NULL,id,deleted_at,NULL',
                "title"                     => 'required',
                "description"               => 'nullable',
                "image"                     => 'required',
                "mrp"                       => 'required',
                "price"                     => 'required',
                "image"                     => 'nullable',
                "gallery1"                  => 'required',
                "gallery2"                  => 'required',
                "gallery3"                  => 'required',
                "feature4"                   => 'required',
                "feature2"                   => 'required',
                "feature3"                   => 'required',
                "feature4"                   => 'required',
                "feature5"                   => 'required',
                "product_specification"      => 'required',
            ],
            (new CommonHelper())->getValidationMessage()
        );
        $this->data     = ["request_key" => $request->request_key];
        if ($validator->fails()) {
            $this->success  = false;
            $this->message  = $validator->errors()->first();
        }

        $item                  =  Item::where('id', $request->title)->first();
        if ($item) {
            $this->message     = "Product already exist";
            $this->success     = false;
        } else {

            $specification      = "";
            $specification      .= "<ul class='product_specification'>";
            if (isset($request->feature1) && $request->feature1) {
                $specification      .= "<li>" . $request->feature1 . "</li>";
            }
            if (isset($request->feature2) && $request->feature2) {
                $specification      .= "<li>" . $request->feature2 . "</li>";
            }
            if (isset($request->feature3) && $request->feature3) {
                $specification      .= "<li>" . $request->feature3 . "</li>";
            }
            if (isset($request->feature4) && $request->feature4) {
                $specification      .= "<li>" . $request->feature4 . "</li>";
            }
            if (isset($request->feature5) && $request->feature5) {
                $specification      .= "<li>" . $request->feature5 . "</li>";
            }
            $specification      .= "</ul>";



            $image_url          = $this->imageUploadFetchUrl($request->image, $request->name);
            $input =  [
                'name'                  => $request->title,
                'sku'                   => $request->sku,
                'descriptions'          => strip_tags($request->description),
                'specification'         => $request->product_specification,
                'features'              => $specification,
                'price'                 => str_replace([',', '₹'], '', $request->price),
                'mrp'                   => str_replace([',', '₹'], '', $request->mrp),
                'vendor_id'             => 1,
                'stock'                 => 1,
                'slug'                  => $this->slugCreateUniq($request->title),
                'is_draft'              => Carbon::now(),
                'is_verified'           => Carbon::now()

            ];
            $input['image']             = $image_url;
            $item =  (new Item())->createItem($input);

            $gallery = [];
            if ($request->gallery1) {
                $gallery[] = [
                    "name"      => $request->title,
                    "image"     => $this->imageUploadFetchUrl($request->gallery1, $request->title),
                    "item_id"   => $item->id,
                ];
            }
            if ($request->gallery2) {
                $gallery[] = [
                    "name"      => $request->title,
                    "image"     => $this->imageUploadFetchUrl($request->gallery2, $request->title),
                    "item_id"   => $item->id,
                ];
            }
            if ($request->gallery3) {
                $gallery[] = [
                    "name"      => $request->title,
                    "image"     => $this->imageUploadFetchUrl($request->gallery3, $request->title),
                    "item_id"   => $item->id,
                ];
            }
            if ($request->gallery4) {
                $gallery[] = [
                    "name"      => $request->title,
                    "image"     => $this->imageUploadFetchUrl($request->gallery4, $request->title),
                    "item_id"   => $item->id,
                ];
            }
            itemImage::insert($gallery);
            $this->success  = true;
            $this->message  = "successfully uploaded";
        }


        return response()->json([
            'success'   => $this->success,
            'message'   => $this->message,
            'data'      => $this->data
        ], $this->code);
    }

    public function slugCreateUniq($slug, $excludeId = null)
    {

        $slug           = Str::slug($slug);
        $originalSlug   = $slug;
        $count          = 1;
        while (Item::where('slug', $slug)
            ->when($excludeId, function ($query, $excludeId) {
                return $query->where('id', '!=', $excludeId);
            })
            ->exists()
        ) {
            $slug = $originalSlug . '-' . $count;
            $count++;
        }
        return $slug;
    }

    public function getUploadFromSheet()
    {
        $sheets     = (new GoogleSheet())->getListFromSheet();
        $categories = Category::all('id', 'name');
        $tags       = productType::all('id', 'name');
        $authors    = Authors::all('id', 'name');
        return view('admin.products.google-sheet-upload', ['sheets' => $sheets, 'categories' => $categories, 'tags' => $tags, 'authors' => $authors]);
    }
}
