<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Validator;
use \Exception;
use App\Helpers\CommonHelper;
use App\Models\Category;
use App\Models\SubCategory;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Storage;


class CategoryController extends Controller
{
    /**
     * Http response data
     */
    private $data;

    /**
     * Http response code
     */
    private $code;

    /**
     * Response status
     */
    private $success;

    /**
     * Response message
     */
    private $message;

    /**
     * Init class attributes
     */
    public function __construct(Request $request)
    {
        $this->data     = new \stdClass();
        $this->code     = Response::HTTP_OK;
        $this->success  = true;
        $this->message  = '';
    }

    /**
     * get all user category list
     * @author  RAHUL
     */
    public function getAllCategories(Request $request)
    {
        $this->data  = ['categories' => (new Category())->getAllCategories($request)];
        return response()->json([
            'success'   => $this->success,
            'message'   => 'Category list successfully retrieved',
            'data'      => $this->data
        ], $this->code);
    }

    /**
     * get all user category list
     * @author  RAHUL
     */
    public function getCategoryList(Request $request)
    {
        $result = (new Category())->getCategoryList($request);
        $this->data  = [
            'results' =>  $result,
            'link' =>  (string) $result->links()
        ];
        return response()->json([
            'success'   => $this->success,
            'message'   => 'Category list successfully retrieved',
            'data'      => $this->data
        ], $this->code);
    }


    /**
     * getSingleCategory
     * @author  RAHUL
     */
    public function getSingleCategory(Request $request)
    {
        $this->data  = ['category' => (new Category())->getSingleCategory($request->id)];
        return response()->json([
            'success'   => $this->success,
            'message'   => 'Category list successfully retrieved',
            'data'      => $this->data
        ], $this->code);
    }

    /**
     * getSubCategory
     * @author  RAHUL
     */
    public function getSubCategory(Request $request)
    {
        $this->data  = ['sub_categories' => (new SubCategory())->getSubCategory($request)];
        return response()->json([
            'success'   => $this->success,
            'message'   => 'Category list successfully retrieved',
            'data'      => $this->data
        ], $this->code);
    }



    /**
     * getCategoryActions
     * @author  RAHUL
     */
    public function getCategoryActions(Request $request)
    {
        if ($request->action == 'edit') {
            (new Category())->updateCategory($request);
        } else if ($request->action == 'delete') {
            (new Category())->deleteCategory($request->id);
        }

        return response()->json([
            'success'   => $this->success,
            'message'   => 'Category  successfully updates',
            'data'      => $this->data
        ], $this->code);
    }

    /**
     * updateCateGory
     * @author  RAHUL
     */
    public function updateCategory(Request $request)
    {
        $validation = Validator::make($request->all(), [
            'name'         => 'required',
            'is_active'    => 'required',
            'image'        => 'image|mimes:jpeg,png,jpg|max:1048|dimensions:ratio=1/1,min_width=100,min_height=100'
        ]);
        if (!$validation->passes()) {
            return response()->json([
                'success'   => false,
                'message'   =>  $validation->errors()->first(),
                'data'      => $this->data
            ], $this->code);
        }
        
        if ($request->hasFile('image')) {
            $file =  $request->file('image');
            $extension = $file->extension();
            $file_name = implode('_', [
                date('YmdHis'),
                Str::slug($request->name, '_')
            ]);

            $path = 'images/category/';
            Storage::disk('local')->putFileAs('public/' . $path, $file, $file_name . '.' . $extension);
            $input = [
                'name'      => $request->name,
                'is_active' => $request->is_active,
                'image'     => '/storage/' . $path . $file_name . '.' . $extension
            ];
        } else {
            $input = [
                'name'      => $request->name,
                'is_active' => $request->is_active,
            ];
        }

        (new Category())->updateCategory($request->id, $input);


        return response()->json([
            'success'   => $this->success,
            'message'   => 'Category  successfully updated',
            'data'      => $this->data
        ], $this->code);
    }

    /**
     * updateCateGory
     * @author  RAHUL
     */
    public function createCategory(Request $request)
    {
        $validation = Validator::make($request->all(), [
            'name'         => 'required',
            'is_active'    => 'required',
            'image'        => 'required|image|mimes:jpeg,png,jpg|max:1048|dimensions:ratio=1/1,min_width=100,min_height=100'
        ]);
        if (!$validation->passes()) {
            return response()->json([
                'success'   => false,
                'message'   => $validation->errors()->first(),
                'data'      => $this->data
            ], $this->code);
        }

        $file =  $request->file('image');
        $extension = $file->extension();
        $file_name = implode('_', [
            date('YmdHis'),
            Str::slug($request->name, '_')
        ]);

        $path = 'images/category/';
        Storage::disk('local')->putFileAs('public/' . $path, $file, $file_name . '.' . $extension);

        $this->data = (new Category())->createCategory([
            'name'      => $request->name,
            'is_active' => $request->is_active,
            'image'     => '/storage/' . $path . $file_name . '.' . $extension,
        ]);

        return response()->json([
            'success'   => $this->success,
            'message'   => 'Category  successfully created',
            'data'      => $this->data
        ], $this->code);
    }


    /**
     * get all user category list
     * @author  RAHUL
     */
    public function getSubCategoryList(Request $request)
    {
        $result =  (new SubCategory())->getSubCategoryList($request);
        $this->data  = [
            'results' =>  $result,
            'link' =>  (string) $result->links()
        ];

        return response()->json([
            'success'   => $this->success,
            'message'   => 'Sub-Category list successfully retrieved',
            'data'      => $this->data
        ], $this->code);
    }


    /**
     * get all user category list
     * @author  RAHUL
     */
    public function getSingleSubCategory(Request $request)
    {
        $this->data  = ['sub_category' => (new SubCategory())->getSingleSubCategory($request->id)];
        return response()->json([
            'success'   => $this->success,
            'message'   => 'Sub-Category list successfully retrieved',
            'data'      => $this->data
        ], $this->code);
    }


    /**
     * 
     * @author  RAHUL
     */
    public function createSubCategoryList(Request $request)
    {
        (new SubCategory())->createSubCategory($request);
        return response()->json([
            'success'   => $this->success,
            'message'   => 'Sub-Category successfully created',
            'data'      => $this->data
        ], $this->code);
    }

    /**
     * 
     * @author  RAHUL
     */
    public function updateSubCategoryList(Request $request)
    {
        (new SubCategory())->updatedSubCategory($request);
        return response()->json([
            'success'   => $this->success,
            'message'   => 'Sub-Category successfully updated',
            'data'      => $this->data
        ], $this->code);
    }

    public function deleteSubCategoryList(Request $request)
    {
        (new SubCategory())->deleteSubCategory($request->id);
        return response()->json([
            'success'   => $this->success,
            'message'   => 'Sub-Category successfully deleted',
            'data'      => $this->data
        ], $this->code);
    }


    /**
     * 
     * 
     */
    public function getCreateSettingsRules()
    {
        return [
            'name'      => 'required|max:50|unique:category,name,NULL,id,deleted_at,NULL',

        ];
    }
}
