<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Validator;
use \Exception;

use App\Helpers\CommonHelper;
use App\Models\Contact;

class ContactController extends Controller
{
    /**
     * Http response data
     */
    private $data;

    /**
     * Http response code
     */
    private $code;

    /**
     * Response status
     */
    private $success;

    /**
     * Response message
     */
    private $message;

    /**
     * Init class attributes
     */
    public function __construct(Request $request)
    {
        $this->data     = new \stdClass();
        $this->code     = Response::HTTP_OK;
        $this->success  = true;
        $this->message  = '';
    }


     /**
     * get all user category list
     * @author  RAHUL
    */
    public function getUserContactUsList(Request $request)
    {
        $result = (new Contact())->getUserContactUsList($request);
        $this->data  = [    'results' =>  $result ,
                            'link' =>  (string) $result->links() 
                        ];
        return response()->json([
                'success'   => $this->success,
                'message'   => 'Contact list successfully retrieved',
                'data'      => $this->data
        ], $this->code);
    }

    public function getDeliveryBoyContactUsList(Request $request)
    {
       $result = (new Contact())->getDeliveryBoyContactUsList($request);
        $this->data  = [    'results' =>  $result ,
                            'link' =>  (string) $result->links() 
                        ];
        return response()->json([
                'success'   => $this->success,
                'message'   => 'Contact list successfully retrieved',
                'data'      => $this->data
        ], $this->code);
    }

    public function getRestaurantContactUsList(Request $request)
    {
       $result = (new Contact())->getRestaurantContactUsList($request);
        $this->data  = [    'results' =>  $result ,
                            'link' =>  (string) $result->links() 
                        ];
        return response()->json([
                'success'   => $this->success,
                'message'   => 'Contact list successfully retrieved',
                'data'      => $this->data
        ], $this->code);
    }

    public function getContacts()
    {
        $user_count            = Contact::where('role_id',1)->count();
        $delivery_boy_count    = Contact::where('role_id',2)->count();
        $store_count           = Contact::where('role_id',3)->count();

        $user                  = (new Contact())->getUserContacts();
        $store                 = (new Contact())->getRestaurantContacts();
        $delivery_boy          = (new Contact())->getDeliveryBoyContacts();

        $this->data   = [    
            'user'               => $user,
            'store'              => $store,
            'delivery_boy'       => $delivery_boy,
            'user_count'         => $user_count,
            'delivery_boy_count' => $delivery_boy_count,
            'store_count'       => $store_count
        ];
        return response()->json([
                'success'   => $this->success,
                'message'   => 'Contact list successfully retrieved',
                'data'      => $this->data
        ], $this->code);
    }

    /**
     * 
     * 
     */
    public function changeStatus(Request $request)
    {
    (new Contact())->changeStatus($request->id);
    return response()->json([
            'success'   => $this->success,
            'message'   => 'Status Updated',
            'data'      => $this->data
    ], $this->code);
}


   
}
