<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Validator;
use \Exception;
use App\Models\Coupon;
use App\Models\CouponRedeemedUser;
use App\Helpers\CommonHelper;
use App\Models\SubCategory;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Storage;
use App\Models\Item;
use Auth;

class CouponController extends Controller
{
    /**
     * Http response data
     */
    private $data;

    /**
     * Http response code
     */
    private $code;

    /**
     * Response status
     */
    private $success;

    /**
     * Response message
     */
    private $message;

    /**
     * Init class attributes
     */
    public function __construct(Request $request)
    {
        $this->data     = new \stdClass();
        $this->code     = Response::HTTP_OK;
        $this->success  = true;
        $this->message  = '';
    }

    //
     /**
     * 
     * @author  Ajmal
    */

    public function create(Request $request)
    {
        return view('admin.coupons.create');
    }   

    public function getCouponIndex(Request $request)
    {
        return view('admin.coupons.list');
    }

    public function createCoupon(Request $request)
    {
       
        $rules              = $this->createCouponRules();
        $this->validate($request, $rules);

            $input =  [
                'name'                      => $request->name,
                'code'                      => $request->code,
                'expiry_date'               => $request->expiry_date,
                'minimum_order'             => $request->minimum_order,
                'discount_percentage'       => $request->discount_percentage,
                'discount_amount'           => $request->discount_amount,
                'total_count'               => $request->total_count,
                'remaining_count'           => $request->total_count,
                'is_active'                 => $request->is_active
             ];
             (new Coupon())->createCoupons($input);
    
             $request->session()->flash('message', 'Coupon created successfully.'); 
             $request->session()->flash('alert-class', 'alert-success'); 
             return redirect('/admin/coupon'); 
        }

        public function edit(Request $request)
        {
            $coupon         = (new Coupon())->getCouponId(base64_decode($request->id));
            return view('admin.coupons.edit',['coupon' => $coupon]);
        }

        public function update(Request $request)
        {
            $rules          = $this->updateCouponRules($request->id);
            $this->validate($request,$rules);
            
            $coupon                      = (new Coupon())->getCouponId($request->id);
            $update_coupon               = (new Coupon())->updateCoupons($request,$coupon->id);
           
    
            if( !$update_coupon)
            {
                $this->success  = false;
                $this->message  = "Failed to update coupon.";
            }
            else
            { 
                $this->message  = "coupon updated successfully.";
            } 
            
            // response
            $request->session()->flash('message', 'Coupon updated successfully.'); 
            $request->session()->flash('alert-class', 'alert-success'); 
            return redirect('/admin/coupon');
            
        }

        public function delete(Request $request)
        {
            $redeemed_users     = (new CouponRedeemedUser())->getUsers($request->id);
            if($redeemed_users->count() > 0)
            {
                $this->success  = false;
                $this->message  = 'Coupon has been already redeemed by an user.';

            }
            else
            {
                (new Coupon())->deleteCoupon($request->id);
                $this->success  = true;
                $this->message  = 'Coupon successfully deleted';
            }
            return response()->json([
                    'success'   => $this->success,
                    'message'   => $this->message,
                    'data'      => $this->data
            ], $this->code);
        }

        public function getCouponList(Request $request)
    {
        $result = (new Coupon())->getCouponList($request);
        $this->data  = [    'results' =>  $result ,
                            'link' =>  (string) $result->links() 
                        ];
        return response()->json([
                'success'   => $this->success,
                'message'   => 'Coupon successfully retrieved',
                'data'      => $this->data
        ], $this->code);
    }

        public function getCouponUsersList(Request $request)
        {

                $coupon        = (new Coupon())->getCouponId(base64_decode($request->id));
                $users         = (new CouponRedeemedUser())->getCouponUsersList($coupon->id);
                return view('admin.coupons.coupon-user-list',['users' => $users,'coupon'=>$coupon]);
            
        }
  
        /**
         * 
         * 
         */
        public function createCouponRules()
        {
            $rules = [

                'name'                      => 'required|min:3|max:200',
                'code'                      => 'required|unique:coupons,code,NULL,id,deleted_at,NULL',
                'expiry_date'               => 'required',
                'minimum_order'             => 'required|numeric',
                'discount_percentage'       => 'required|numeric',
                'discount_amount'           => 'required|numeric',
                'total_count'               => 'required|numeric',
                'is_active'                 => 'required'
            ];
            return $rules;
        }

        public function updateCouponRules($id)
        {
            $rules = [

                'name'                      => 'required|min:3|max:200',
                'code'                      => 'required|unique:coupons,code,'.$id.',id,deleted_at,NULL',
                'expiry_date'               => 'required',
                'minimum_order'             => 'required|numeric',
                'discount_percentage'       => 'required|numeric',
                'discount_amount'           => 'required|numeric',
                'total_count'               => 'required|numeric',
                'remaining_count'           => 'required|numeric',
                'is_active'                 => 'required'
            ];
            return $rules;
        }

}
