<?php

namespace App\Http\Controllers;

use App\Models\User;
use App\Models\Order;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Validator;
use Exception;
use Illuminate\Hashing\BcryptHasher;
use Illuminate\Support\Facades\Hash;
use App\Helpers\CommonHelper;

class CustomerController extends Controller
{

         /**
         * Http response data
         */
        private $data;

        /**
         * Http response code
         */
        private $code;

        /**
         * Response status
         */
        private $success;

        /**
         * Response message
         */
        private $message;

        /**
         * Init class attributes
         */
        public function __construct(Request $request)
        {
            $this->data     = new \stdClass();
            $this->code     = Response::HTTP_OK;
            $this->success  = true;
            $this->message  = '';
        }
       

        /**
         * get all users list
         * @author  SOORYA
        */
        public function getUserList(Request $request)
        {
            $result         =  (new User())->getUserList($request);
            $this->data     =  [    'results' =>  $result ,
                                    'link' =>  (string) $result->links() 
                                ];
            return response()->json([
                    'success'   => $this->success,
                    'message'   => 'User successfully retrieved',
                    'data'      => $this->data
            ], $this->code);
        }

        /**
         * 
         * Edit Password
         * 
         */
        public function editPassword(Request $request)
        {

            $user   = (new User())->getSingleUser(base64_decode($request->id));
            return view('admin.customers.change-password',[
                'user'         => $user
            ]);
        }

        public function updatePassword(Request $request)
        {
        
            $rules              = $this->updatePasswordRules();
            $this->validate($request, $rules);

            $user      = (new User())->getUserById($request->id);

            if( !$user )
            {
                $this->success  = false;
                $this->message  = "No User Found.";
            }
            else
            { 
                $hashed_password  = (new BcryptHasher)->make($request->password);   
                (new User())->updatePassword($request->id,['password' => $hashed_password]);
                $this->message    = 'password successfully updated';
            } 
            
            $request->session()->flash('message', 'User Password successfully updated'); 
            $request->session()->flash('alert-class', 'alert-success'); 
            return redirect('/admin/customers');
        }


        /**
         * 
         * 
         */
        public function updatePasswordRules()
        {
            $rules = [
                'password'          => 'required_with:confirm_password|min:6|max:20',
                'confirm_password'  => 'same:password|required|min:6|max:20'
            ];
            return $rules;
        }
      

}
