<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Auth;
use App\Models\Order;
use App\Models\OrderDetail;
use App\Models\Item;
use Illuminate\Support\Str;

class DashboardController extends Controller
{
    

     /**
     * Http response data
     */
    private $data;

    /**
     * Http response code
     */
    private $code;

    /**
     * Response status
     */
    private $success;

    /**
     * Response message
     */
    private $message;

    /**
     * Init class attributes
     */
    public function __construct(Request $request)
    {
        $this->data     = new \stdClass();
        $this->code     = Response::HTTP_OK;
        $this->success  = true;
        $this->message  = '';
        $this->middleware('auth');
    }

   
    public function getAdminDashboardData(Request $request)
    {

            $order_by_payment_options = (new Order())->getAdminTotalOrdersByPaymentOption();
            $last_15_days_orders      = (new OrderDetail())->getAdminLast15DaysOrders();
            $most_vendors             = (new OrderDetail())->getMostVendorOrders();
            $most_resellers           = (new OrderDetail())->getMostResellerOrders();
            $last_orders = [];
            $last_15_days             = [];
            for($each_date  = strtotime('-14 days'); $each_date <= strtotime(now()) ; $each_date = strtotime('+1 day', $each_date))
            {
            $last_15_days[] = date('d/m/Y',$each_date);
            }
            foreach ($last_15_days as $key => $date) 
            {
                $is_not_exist = true;
            foreach ($last_15_days_orders as  $order) 
            {
                    if($date ==  date('d/m/Y',strtotime($order->date)) )
                    {
                        $last_orders['date'][]  = $date;
                        $last_orders['total'][] = $order->total;
                        $last_orders['cost'][] = $order->total_cost;
                        $is_not_exist = false;
                    }
            }
            if($is_not_exist)
            {
                $last_orders['date'][]  = $date;
                $last_orders['total'][]  = 0;
                $last_orders['cost'][]  = 0;
            }
            }
        
            $vendors                         = [];
            foreach ($most_vendors as $key => $vendor) 
            {
                $vendors[] = [
                        'name'            => $vendor->vendor->name,
                        'order'           => $vendor->orders,
                        'phone'           => $vendor->vendor->phone
    
                ];
            }

            $resellers                         = [];
            foreach ($most_resellers as $key => $reseller) 
            {
                $resellers[] = [
                        'name'            => $reseller->reseller->name,
                        'order'           => $reseller->orders,
                        'phone'           => $reseller->reseller->phone
    
                ];
            }

            $payment_data = [];
            foreach ($order_by_payment_options as $key => $payment) 
            {
                $payment_data['options'][] = $payment->paymentOption->name;
                $payment_data['orders'][] = $payment->orders;
            }
            $this->data = [
                'order_by_payment_options' => $payment_data,
                'total_revenue' => (new OrderDetail())->getAdminTotalRevenue(),
                'total_orders' => (new OrderDetail())->getAdminTotalOrders(),
                'total_products' => (new Item())->getAdminTotalItems(),
                'vendors'  => $vendors,
                'resellers'  => $resellers,
                'last_15_days_orders' => $last_orders,
                'days_15_total_orders' =>  array_sum($last_orders['total']),
                'days_15_total_revenue' => number_format(array_sum($last_orders['cost']) , 2),
                'summary' => 'All Time Summary'
            ];
            // response
            return response()->json([
                'success'   => $this->success,
                'message'   => $this->message ,
                'data'      => $this->data
            ], $this->code);
    }
}
