<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\DeliveryPartner;
use Illuminate\Http\Response;

class DeliveryPartnerController extends Controller
{
    /**
     * Http response data
     */
    private $data;

    /**
     * Http response code
     */
    private $code;

    /**
     * Response status
     */
    private $success;

    /**
     * Response message
     */
    private $message;

    /**
     * Init class attributes
     */
    public function __construct(Request $request)
    {
        $this->data     = new \stdClass();
        $this->code     = Response::HTTP_OK;
        $this->success  = true;
        $this->message  = '';
    }
    public function getDeliveryPartnersList(Request $request)
    {
        $result = (new DeliveryPartner())->getDeliveryPartnersList($request) ;
        $this->data  = [    'results' =>  $result ,
                            'link' =>  (string) $result->links() 
                        ];
        return response()->json([
                'success'   => $this->success,
                'message'   => 'Delivery Partners list successfully retrieved',
                'data'      => $this->data
        ], $this->code);
    }

    public function saveDeliveryPartner(Request $request)
    {
        $this->validate($request, [
            'name' => 'required'
        ]);
        (new DeliveryPartner())->createDeliveryPartner([
            'name'      => $request->name,
            'address'   => $request->address,
            'link'      => $request->link

        ]);
        return redirect(url('/admin/delivery-partners'));
    }

    public function editDeliveryPartner(Request $request)
    {
        $delivery_partner = DeliveryPartner::find(base64_decode($request->id));
        return view('admin.delivery-partners.edit', compact('delivery_partner'));
    }

    public function updateDeliveryPartner(Request $request)
    {
        $this->validate($request, [
            'name' => 'required'
        ]);
        $delivery_partner = DeliveryPartner::find($request->id);
        (new DeliveryPartner())->updateDeliveryPartner($delivery_partner->id, [
            'name'      => $request->name,
            'address'   => $request->address,
            'link'      => $request->link
        ]);
        return redirect(url('/admin/delivery-partners'));
    }

    public function deleteDeliveryPartner(Request $request)
    {
        (new DeliveryPartner())->deleteDeliveryPartner($request->id);
        return response()->json([
                'success'   => $this->success,
                'message'   => 'Delivery Partner successfully deleted',
                'data'      => $this->data
        ], $this->code);
    }
}
