<?php

namespace App\Http\Controllers;

use App\Helpers\CommonHelper;
use App\Models\Authors;
use App\Models\Category;
use Illuminate\Support\Facades\Storage;
use App\Models\GoogleSheet;
use App\Models\productType;
use App\Models\User;
use App\Services\GoogleSheetsService;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Validator;
use Socialite;
use Auth;


class GoogleLogiController extends Controller
{

    /**
     * Http response data
     */
    private $data;

    /**
     * Http response code
     */
    private $code;

    /**
     * Response status
     */
    private $success;

    /**
     * Response message
     */
    private $message;

    /**
     * Init class attributes
     */


    protected $googleSheetsService;
    public function __construct(GoogleSheetsService $googleSheetsService)
    {
        $this->googleSheetsService = $googleSheetsService;
        $this->data     = new \stdClass();
        $this->code     = Response::HTTP_OK;
        $this->success  = true;
        $this->message  = '';
    }

    public function redirectToGoogle()
    {
        return Socialite::driver('google')->redirect();
    }

    public function handleGoogleCallback()
    {
        $googleUser = Socialite::driver('google')->user();
        $user = User::where('google_id', $googleUser->getId())->first();
        if (!$user) {
            $user = User::create([
                'name'               => $googleUser->getName(),
                'email'              => $googleUser->getEmail(),
                'google_id'          => $googleUser->getId(),
                'profile_picture'    => $googleUser->getAvatar(),
                'role_id'            => 1
            ]);
        }
        Auth::login($user, true);
        return redirect()->route('home');
    }
}
