<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Validator;
use \Exception;
use App\Helpers\CommonHelper;
use App\Models\Color;
use App\Models\Size;
use App\Models\Category;
use App\Models\Item;
use App\Models\ItemImage;
use Auth;

class ItemController extends Controller
{
    /**
     * Http response data
     */
    private $data;

    /**
     * Http response code
     */
    private $code;

    /**
     * Response status
     */
    private $success;

    /**
     * Response message
     */
    private $message;

    /**
     * Init class attributes
     */
    public function __construct(Request $request)
    {
        $this->data     = new \stdClass();
        $this->code     = Response::HTTP_OK;
        $this->success  = true;
        $this->message  = '';
    }

    /**
     * get all user category list
     * @author  RAHUL
    */
    public function create(Request $request)
    {
        $this->data  =  [   'sizes'         =>  (new Size())->getAllSizes() ,
                            'colors'        =>  (new Color())->getAllColors() ,
                            'categories'    =>  (new Category())->getAllCategories() ,
                            'sub_categories'=>  (new SubCategory())->getAllSubCategories() ,
                        ];
        return view('admin.products.create-product',$this->data);
    }


    public function editProduct(Request $request , $uid)
    {
       
         $this->data  =  [  'colors'        => [],
                            'sizes'         => [],
                            'product'       =>  (new Item)->getItemByUid($uid),
                            'categories'    =>  (new Category())->getAllCategories() ,
                        ];
        return view('admin.products.edit-product',$this->data);
    }
 
    /**
     * 
     * @author  RAHUL
    */
    public function createNewItem(Request $request)
    {
        $input =  [
            'store_id'        => Auth::user()->id,
            'name'            => $request->name,
            'descriptions'    => $request->descriptions,
            'mrp'             => str_replace([',','₹'],'',$request->mrp),
            'cost'            => str_replace([',','₹'],'',$request->cost),
            'store_cost'       => str_replace([',','₹'],'',$request->store_cost),
            'sku'             =>  (new CommonHelper)->generateSKU( Auth::user() ),
            'stock_status'    => $request->stock_status,
            'instock_quantity'=> str_replace([',','₹'],'',$request->instock_quantity),
            'category_id'     => $request->category_id,
         ];
         $item =  (new Item())->createItem($input);
         (new itemImage())->createItemImage( $item , explode(',', $request->item_image) );
         return response()->json([
                'success'   => $this->success,
                'message'   => 'Product list successfully retrieved',
                'data'      => $this->data
        ], $this->code);
    }

    public function updateProduct(Request $request)
    {
        $item = (new Item)->getItemByUid($request->uid);
        $input =  [
            'name'              => $request->name,
            'descriptions'      => $request->descriptions,
            'mrp'               => str_replace([',','₹'],'',$request->mrp),
            'cost'              => str_replace([',','₹'],'',$request->cost),
            'store_cost'        => str_replace([',','₹'],'',$request->store_cost),
            'stock_status'      => $request->stock_status,
            'instock_quantity'  => str_replace([',','₹'],'',$request->instock_quantity),
            'category_id'       => $request->category_id,
         ];
         $this->data = (new Item())->updateItem($item->id, $input);
         (new ItemImage())->deleteItemImages($item->id);
         (new ItemImage())->createItemImage( $item , explode(',', $request->item_image) );
         return response()->json([
                'success'   => $this->success,
                'message'   => 'Product list successfully retrieved',
                'data'      => $this->data
        ], $this->code);
    }

     /**
     * get all user category list
     * @author  RAHUL
    */
    public function getItemList(Request $request)
    {
        $result = (new Item())->getItemList($request);
        $this->data  = [    'results' =>  $result ,
                            'link' =>  (string) $result->links() 
                        ];
        return response()->json([
                'success'   => $this->success,
                'message'   => 'Product list successfully retrieved',
                'data'      => $this->data
        ], $this->code);
    }




    /**
     * 
     * 
     */
    public function getCreateFolderRules()
    {
        return [           
            'folder'      => 'required|unique:sizes,name,NULL,id,deleted_at,NULL',
           
        ];
    }

   
}
