<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Support\Carbon;
use App\Models\Order;
use App\Models\OrderDetail;
use App\Models\OrderStatus;
use App\Models\Vendor;
use App\Models\Reseller;
use App\Events\OrderEvent;
use App\Traits\OrderTrait;
use Illuminate\Support\Facades\Storage;
use PDF;
class OrderController extends Controller
{
    /**
     * Http response data
     */
    private $data;

    /**
     * Http response code
     */
    private $code;

    /**
     * Response status
     */
    private $success;

    /**
     * Response message
     */
    private $message;

    /**
     * Init class attributes
     */
    public function __construct(Request $request)
    {
        $this->data     = new \stdClass();
        $this->code     = Response::HTTP_OK;
        $this->success  = true;
        $this->message  = '';
    }

  
    
    /*
     *
     *
     * 
     */
    public function orderDetailsAdmin(Request $request ,$uid)
    {
         $this->data = [
            'order'             =>(new Order)->getOrderByUid($uid),
            'order_statuses'    =>(new OrderStatus)->getOrderStatuses(),
        ];
        return view('admin.orders.order-detail',$this->data);
    }



   /**
     * get store order list
     * @author  RAHUL
    */
    public function getAdminOrdersList(Request $request)
    {
        $result = (new Order())->getAdminOrdersList($request);
        $this->data  = [    'results' =>  $result ,
                            'link' =>  (string) $result->links() 
                        ];
        return response()->json([
                'success'   => $this->success,
                'message'   => 'Orders list successfully retrieved',
                'data'      => $this->data
        ], $this->code);
    }

    public function orderStatusChange(Request $request)
    {
        $order            = (new OrderDetail)->getOrderProductById($request->id, $request->item_id);

        if(!empty($order))
        {
            (new OrderDetail)->updateOrder($order->id, ['order_status_id' => $request->order_status_id ]);
            event(new OrderEvent($order->id, 'users'));
            event(new OrderEvent($order->id, 'vendors'));
        }
        return response()->json([
                'success'   => $this->success,
                'message'   => 'Orders status successfully updated',
                'data'      => $this->data
        ], $this->code);
    }



    /*
     *
     *
     * 
     */
    public function orderDetailsPDF(Request $request ,$uid)
    {
        $order = (new Order)->getOrderByUid($uid);
         $this->data = [
            'order'             => $order,
            'order_statuses'    =>(new OrderStatus)->getOrderStatuses(),
        ];

        $path               = "pdf/order-detail/";
        $pdf_name           = $order->invoice_number."_order_details.pdf";
        $final_path         = '/storage/' .$path.$pdf_name;
        $pdf                = PDF::loadView('admin.orders.order-detail-pdf', $this->data );
        Storage::disk('local')->put('public/pdf/order-detail/'.$pdf_name,$pdf->output());
        return $pdf->download($pdf_name);
    }
  
    public function salesReport(Request $request)
    {
        $this->from_date    = null;
        $this->to_date      = null;
        $this->vendor       = null;

        
        if($request->from_date && $request->to_date && $request->vendor)
        {
            $this->from_date    = $request->from_date;
            $this->to_date      = $request->to_date;
            $this->vendor       = $request->vendor;
            $from               = Carbon::parse($this->from_date)->format('Y-m-d');
            $to                 = Carbon::parse($this->to_date)->format('Y-m-d');
            $orders             = OrderDetail::whereDate('created_at','>=',$from)
                                            ->whereDate('created_at','<=',$to)
                                            ->where('vendor_id',$request->vendor)
                                            ->with('order:id,invoice_number')
                                            ->orderBy('id','ASC')
                                            ->get();
        }
        else
        {
            $orders             = [];
        }
        $vendors = Vendor::all();
        return view('admin.reports.sales-report', [
            'vendors'           => $vendors,
            'orders'            => $orders,
            'from_date'         => $this->from_date,
            'to_date'           => $this->to_date,
            'vendor'            => $this->vendor
            
        ]);
    }


    public function salesReportPDF(Request $request)
    {
        $this->from_date    = $request->from_date;
        $this->to_date      = $request->to_date;
        $this->vendor       = $request->vendor;

        $from               = Carbon::parse($this->from_date)->format('Y-m-d');

        $to                 = Carbon::parse($this->to_date)->format('Y-m-d');
                               
        
        $orders             = Order::whereDate('created_at','>=',$from)
                                    ->whereDate('created_at','<=',$to)
                                    ->where('vendor_id',$request->vendor)
                                    ->with('order:id,invoice_number')
                                    ->orderBy('id','ASC')
                                    ->get();

        $vendor_name         = Vendor::select('name')->where('id',$request->vendor)->first();

        $pdf = PDF::loadView('admin.reports.sales-report-pdf', ['orders' => $orders, 'from'=> $from,'to'=>$to , 'vendor'=> $vendor_name]);
        $pdf->save(storage_path().'_filename.pdf');
        return $pdf->download( $vendor_name->name.'_Vendor_Sales_Report_'.$from.'_'.$to.'.pdf');
    }

    public function resellerSalesReport(Request $request)
    {
        $this->from_date    = null;
        $this->to_date      = null;
        $this->reseller     = null;

        
        if($request->from_date && $request->to_date && $request->reseller)
        {
            $this->from_date    = $request->from_date;
            $this->to_date      = $request->to_date;
            $this->reseller     = $request->reseller;
            $from               = Carbon::parse($this->from_date)->format('Y-m-d');
            $to                 = Carbon::parse($this->to_date)->format('Y-m-d');
            $orders             = OrderDetail::whereDate('created_at','>=',$from)
                                        ->whereDate('created_at','<=',$to)
                                        ->where('reseller_id',$request->reseller)
                                        ->with('order:id,invoice_number')
                                        ->orderBy('id','ASC')
                                        ->get();
        }
        else
        {
            $orders             = [];
        }
        $resellers = Reseller::all();
        return view('admin.reports.reseller-sales-report', [
            'resellers'         => $resellers,
            'orders'            => $orders,
            'from_date'         => $this->from_date,
            'to_date'           => $this->to_date,
            'reseller'          => $this->reseller
            
        ]);
    }
    
    public function resellerSalesReportPDF(Request $request)
    {
        $this->from_date    = $request->from_date;
        $this->to_date      = $request->to_date;
        $this->reseller     = $request->reseller;

        $from               = Carbon::parse($this->from_date)->format('Y-m-d');

        $to                 = Carbon::parse($this->to_date)->format('Y-m-d');
                               
        
        $orders             = OrderDetail::whereDate('created_at','>=',$from)
                                    ->whereDate('created_at','<=',$to)
                                    ->where('reseller_id',$request->reseller)
                                    ->with('order:id,invoice_number')
                                    ->orderBy('id','ASC')
                                    ->get();

        $reseller_name         = Reseller::select('name')->where('id',$request->reseller)->first();

        $pdf = PDF::loadView('admin.reports.reseller-sales-report-pdf', ['orders' => $orders, 'from'=> $from,'to'=>$to , 'reseller'=> $reseller_name]);
        $pdf->save(storage_path().'_filename.pdf');
        return $pdf->download( $reseller_name->name.'_Reseller_Sales_Report_'.$from.'_'.$to.'.pdf');
    }
 
}
