<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Validator;
use \Exception;
use App\Helpers\CommonHelper;
use App\Models\productType;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Storage;
use Auth;

class ProductTypeController extends Controller
{
    /**
     * Http response data
     */
    private $data;

    /**
     * Http response code
     */
    private $code;

    /**
     * Response status
     */
    private $success;

    /**
     * Response message
     */
    private $message;

    /**
     * Init class attributes
     */
    public function __construct(Request $request)
    {
        $this->data     = new \stdClass();
        $this->code     = Response::HTTP_OK;
        $this->success  = true;
        $this->message  = '';
    }



    public function getProductIndex()
    {

        return view('admin.product-type.list');
    }




    /**
     * get all user product-type list
     * @author  SOORYA
     */
    public function getProductList(Request $request)
    {
        $result = (new productType())->getAdminProductList($request);
        $this->data  = [
            'results' =>  $result,
            'link' =>  (string) $result->links()
        ];
        return response()->json([
            'success'   => $this->success,
            'message'   => 'Product Type list successfully retrieved',
            'data'      => $this->data
        ], $this->code);
    }

    public function getAllProductTypes(Request $request)
    {
        $this->data  = ['product-types' => (new productType())->getAdminProductTypes($request)];
        return response()->json([
            'success'   => $this->success,
            'message'   => 'Product Type list successfully retrieved',
            'data'      => $this->data
        ], $this->code);
    }

    /**
     * getSingleProductType
     * @author  SOORYA
     */
    public function getSingleProduct(Request $request)
    {
        $this->data  = ['product' => (new productType())->getSingleProduct($request->id)];
        return response()->json([
            'success'   => $this->success,
            'message'   => 'Product Type list successfully retrieved',
            'data'      => $this->data
        ], $this->code);
    }
    /**
     * getProductTypesByStore
     * @author  PMS
     */
    public function getProductTypes(Request $request)
    {
        $this->data  = ['product-types' => (new productType())->getProductTypes($request)];
        return response()->json([
            'success'   => $this->success,
            'message'   => 'Product Type list successfully retrieved',
            'data'      => $this->data
        ], $this->code);
    }

    /**
     * updateProduct 
     * @author  SOORYA
     */

    public function edit(Request $request)
    {
        $product  = productType::find(base64_decode($request->id));
        return view('admin.product-type.edit', ['product' => $product]);
    }

    public function update(Request $request)
    {
        $validation = Validator::make($request->all(), [

            'name'         => 'required',
            'slug'         => 'required'

        ]);
        if (!$validation->passes()) {
            return response()->json([
                'success'   => false,
                'message'   =>  $validation->errors()->first(),
                'data'      => $this->data
            ], $this->code);
        }

        $input = [
            'name'          => $request->name,
            'slug'          => $request->slug
        ];

        (new productType())->updateProduct($request->id, $input);

        return redirect('/admin/product-types');
    }

    /**
     * updateProduct
     * @author  SOORYA
     */

    public function create(Request $request)
    {
        return view('admin.product-type.create');
    }

    /**
     * updateproduct
     * @author  SOORYA
     */

    public function createProduct(Request $request)
    {
        $validation = Validator::make($request->all(), [
            'name'         => 'required',
            'slug'         => 'required'
        ]);
        if (!$validation->passes()) {
            return response()->json([
                'success'   => false,
                'message'   => $validation->errors()->first(),
                'data'      => $this->data
            ], $this->code);
        }

        (new productType())->createProduct([
            'name'      => $request->name,
            'slug'      => $request->slug
        ]);

        $request->session()->flash('message', 'Product Type successfully Created');
        $request->session()->flash('alert-class', 'alert-success');
        return redirect('/admin/product-types');
    }

    public function delProduct(Request $request)
    {
        (new productType())->delProduct($request->id);
        return response()->json([
            'success'   => $this->success,
            'message'   => 'Product Type successfully deleted',
            'data'      => $this->data
        ], $this->code);
    }
}
