<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Http\Response;
use App\Models\Coupon;
use App\Models\PushNotification;
use App\Jobs\UserMultiplePushNotification;
use App\User;
use App\Models\UserDevice;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Storage;
use App\Helpers\PushNotificationHelper;
use App\Models\PushNotificationUser;
class PushNotificationController extends Controller
{
    /**
     * Http response data
     */
    private $data;

    /**
     * Http response code
     */
    private $code;

    /**
     * Response status
     */
    private $success;

    /**
     * Response message
     */
    private $message;

    /**
     * Init class attributes
     */
    public function __construct(Request $request)
    {
        $this->data     = new \stdClass();
        $this->code     = Response::HTTP_OK;
        $this->success  = true;
        $this->message  = '';
    }

    /**
    * 
    * @author  Soorya
    */

    public function create(Request $request)
    {
        
        return view('admin.push-notification.create');
        
    }   

    public function getPushNotificationIndex(Request $request)
    {
        return view('admin.push-notification.list');
    }

    public function createPushNotification(Request $request)
    {
        $rules              = $this->createPushNotificationRules();
        $this->validate($request, $rules);
       
            $input =  [
                'title'                 => $request->title,
                'description'           => $request->description
             ];
             if($request->file('image'))
             {
                 $image                     = $request->file('image');
                 if($image)
                 {
                    $extension               = $image->extension();
                    $file_name               = 'pumqi_'.time().'image';
                    $path                    = 'images/notification/';
                    Storage::disk('local')->putFileAs('public/'.$path, $image,$file_name .'.'. $extension);
                    $image                       = '/storage/'.$path. $file_name .'.'. $extension; 
                    $input['image']          = $image;
                 }
             }
            $push_notification               =  (new PushNotification())->createPushNotifications($input);
            if($push_notification)
            {
                $image                       = config('app.url').$push_notification->image;
                $limit                       = 800;
                $offset                      = 0;     
                $count_users                 = (new User())->getUsersCount();
                $total_pages                 = (int)ceil($count_users/$limit);                
                for($i=0;$i <    $total_pages;$i++)
                {
                    $user_list               = (new User())->getUserForPushUserIds($limit,$offset);
                    $users                   = (new User())->getUserIdForPush($limit,$offset);
                    $firebase_token          =  (new UserDevice())->userFirebaseTokenListByUserIds($user_list);

                    UserMultiplePushNotification::dispatch($users,$firebase_token,$push_notification->title,$push_notification->description,$push_notification->id,$image);
                    $next_index              = $i+1;
                    $offset                  = $next_index * $limit;
                }
            }
            $request->session()->flash('message', 'Push Notification created successfully.'); 
            $request->session()->flash('alert-class', 'alert-success'); 
            return redirect('/admin/push-notification'); 
        }
        public function getPushNotificationList(Request $request)
        {
            $result      = (new PushNotification())->getPushNotificationLists($request);
            $this->data  = [    'results' =>  $result ,
                                'link' =>  (string) $result->links() 
                            ];
            return response()->json([
                    'success'   => $this->success,
                    'message'   => 'Push Notification successfully retrieved',
                    'data'      => $this->data
            ], $this->code);
        }

        public function viewNotificationUsers(Request $request)
        {
            $users         = (new PushNotificationUser())->getNotifcationUsers(base64_decode($request->id));
            return view('admin.push-notification.view',['users' => $users]);
        }

        /**
        * 
        * 
        */
        public function createPushNotificationRules()
        {
            $rules = [

                'title'                      => 'required|min:3|max:200',
                'description'                => 'required'
            ];
            return $rules;
        }
}
