<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Http\Response;
use App\Models\Reseller;
use App\Models\UserAddress;
use Illuminate\Hashing\BcryptHasher;
use App\User;
use Validator;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Carbon;
use App\Models\ResellerAccount;

class ResellerController extends Controller
{
            /**
     * Http response data
     */
    private $data;

    /**
     * Http response code
     */
    private $code;

    /**
     * Response status
     */
    private $success;

    /**
     * Response message
     */
    private $message;

    /**
     * Init class attributes
     */
    public function __construct(Request $request)
    {
        $this->data     = new \stdClass();
        $this->code     = Response::HTTP_OK;
        $this->success  = true;
        $this->message  = '';
    }
    
        /**
     * @param  Request
     * @return json
     */
    public function create(Request $request)
    {
        $this->user       = null;
        if($request->user)
        {
            $this->user   = $request->user;
            $users        = User::where('id',$request->user)
                                ->orderBy('id','ASC')
                                ->get();
        }
        else
        {
            $users        = [];
        }
        $users = User::where('is_reseller',null)->get();
        return view('admin.reseller.create',[
            'users'       => $users,
            'user'        => $this->user
        ]);
    }   
    public function createReseller(Request $request)
    {
        if($request->user == '')
        {
            $rules              = $this->createResellerRules();
            $this->validate($request, $rules);

            $password           = $request->password;
            $hashed_password    = (new BcryptHasher)->make($request->password);      
            $user               = (new User())->createNewUser([
                'name'          => trim( ucfirst($request->name)),
                'address'       => trim( $request->address),
                'is_active'     => $request->is_active,
                'email'         => trim( $request->email),
                'phone'         => trim( $request->phone),
                'role_id'       => 3,
                'password'      => $hashed_password,
                'is_reseller'   => Carbon::now()->format('Y-m-d H:i:s')
            ]);  
            if($user)
            {
                $reseller           = (new Reseller())->createReseller($request, $user->id);
                if( !$reseller )
                {
                    $this->success  = false;
                    $this->message  = "Failed to create Reseller.";
                }
                else
                { 
                    (new ResellerAccount())->createNewResellerAccount($request, $reseller->id);
                    $this->message  = "Reseller created successfully.";
                } 
            }
            
            // response
            $request->session()->flash('message', 'Reseller created successfully.'); 
            $request->session()->flash('alert-class', 'alert-success'); 
            return redirect('/admin/reseller');
        }
        else
        {
            $rules                 = $this->createNewResellerRules();
            $this->validate($request, $rules);
    
            $user                  = (new User())->getUserById($request->user);
            $update_user           = (new User())->createNewUserReseller($request,$user->id);

            if($user)
            {
                $reseller           = (new Reseller())->createReseller($request, $user->id);
                if( !$reseller )
                {
                    $this->success  = false;
                    $this->message  = "Failed to create Reseller.";
                }
                else
                { 
                    (new ResellerAccount())->createNewResellerAccount($request, $reseller->id);
                    $this->message  = "Reseller created successfully.";
                } 
            }

            // response
            $request->session()->flash('message', 'Reseller created successfully.'); 
            $request->session()->flash('alert-class', 'alert-success'); 
            return redirect('/admin/reseller');
        }
      
    }

    /**
     * @param  Request
     * @return json
     * @author PMS
     */
    public function getResellerList(Request $request)
    {
        $result         =  (new Reseller())->getResellerList($request);
        $this->data     =  [    'results' =>  $result ,
                                'link' =>  (string) $result->links() 
                            ];
        return response()->json([
                'success'   => $this->success,
                'message'   => 'Resellers successfully retrieved',
                'data'      => $this->data
        ], $this->code);
    }
    
    /**
     * 
     * 
     */
    public function editReseller(Request $request)
    {
        $reseller         = (new Reseller())->getSingleReseller(base64_decode($request->id));
        return view('admin.reseller.edit',['reseller' => $reseller]);
    }

    /**
     * 
     * 
     */

    public function updateReseller(Request $request)
    {
        $rules                 = $this->updateResellerRules($request->id);
        $this->validate($request,$rules);
        
        $reseller                  = (new Reseller())->getSingleReseller($request->id);
        $update_reseller           = (new Reseller())->updateReseller($request,$reseller->id);
        if( !$update_reseller)
        {
            $this->success  = false;
            $this->message  = "Failed to update reseller.";
        }
        else
        { 
            $this->message  = "reseller updated successfully.";
        } 
        
        // response
        $request->session()->flash('message', 'Reseller updated successfully.'); 
        $request->session()->flash('alert-class', 'alert-success'); 
        return redirect('/admin/reseller');
        
    }


    /**
     * 
     * 
     */

    public function delReseller(Request $request)
    {
        (new Reseller())->delReseller($request->id);
        return response()->json([
                'success'   => $this->success,
                'message'   => 'Reseller successfully deleted',
                'data'      => $this->data
        ], $this->code);
    }

    public function updateResellerStatus(Request $request)
    {
        $change_status       = (new Reseller())->changeStatus($request->id);
        if($change_status)
        {
            $reseller    = (new Reseller())->getSingleReseller($request->id);
        }
        return response()->json([
            'success'   => $this->success,
            'message'   => 'Reseller Status Updated',
            'data'      => $this->data
        ], $this->code);
    }

    /**
     * 
     * 
     */
    public function userAddressList(Request $request)
    {
        $reseller           = (new Reseller())->getResellerById(base64_decode($request->id));
        return view('admin.reseller.address-list',['reseller' => $reseller]);
    }

    /**
     * 
     * 
     */
    public function getUserAddressList(Request $request)
    {
        $result         =  (new UserAddress())->getUserAddressList($request);
        $this->data     =  [    'results' =>  $result ,
                                'link' =>  (string) $result->links() 
                            ];
        return response()->json([
                'success'   => $this->success,
                'message'   => 'Reseller address successfully retrieved',
                'data'      => $this->data
        ], $this->code);
    }

    public function getVendorDetails(Request $request)
    {
        $user = (new User())->getVendor($request);
        $this->data = $user;
        return response()->json([
            'success'   => $this->success,
            'message'   => 'user successfully retrieved',
            'data'      => $this->data
        ], $this->code);

    }
    
    public function createResellerRules()
    {
        $rules =  [
            'pincode'           => 'required|digits:6',
            'name'              => 'required|min:3|max:200',
            'phone'             => 'required|numeric|digits:10|unique:resellers,phone,NULL,id,deleted_at,NULL',
            'whatsapp_no'       => 'required|numeric|digits:10|unique:resellers,whatsapp_no,NULL,id,deleted_at,NULL',
            'address'           => 'required',
            'email'             => 'required|email|max:100|unique:resellers,email,NULL,id,deleted_at,NULL',
            'account_name'      => 'required|min:3|max:200',
            'account_number'    => 'required|regex:/^\d{9,18}$/|unique:resellers,account_number,NULL,id,deleted_at,NULL',
            'bank_name'         => 'required|min:3|max:200',
            'branch_name'       => 'required|min:3|max:200',
            'ifsc'              => 'required|regex:/^[A-Za-z]{4}\d{7}$/',
            'upi_id'            => 'required|regex:/^[\w.-]+@[\w.-]+$/',
            'password'          => 'required_with:confirm_password|min:6|max:20',
            'confirm_password'  => 'same:password|required|min:6|max:20'
            
        ];
        return $rules;
    }

    public function createNewResellerRules()
    {
        $rules =  [
            'pincode'           => 'required|digits:6',
            'name'              => 'required|min:3|max:200',
            'phone'             => 'required|numeric|digits:10|unique:resellers,phone,NULL,id,deleted_at,NULL',
            'whatsapp_no'       => 'required|numeric|digits:10|unique:resellers,whatsapp_no,NULL,id,deleted_at,NULL',
            'address'           => 'required',
            'email'             => 'required|email|max:100|unique:resellers,email,NULL,id,deleted_at,NULL',
            'account_name'      => 'required|min:3|max:200',
            'account_number'    => 'required|regex:/^\d{9,18}$/|unique:resellers,account_number,NULL,id,deleted_at,NULL',
            'bank_name'         => 'required|min:3|max:200',
            'branch_name'       => 'required|min:3|max:200',
            'ifsc'              => 'required|regex:/^[A-Za-z]{4}\d{7}$/',
            'upi_id'            => 'required|regex:/^[\w.-]+@[\w.-]+$/'
            
        ];
        return $rules;
    }


    public function updateResellerRules($id)
    {
        $rules =  [
            'pincode'           => 'required|digits:6',
            'name'              => 'required|min:3|max:200',
            'phone'             => 'required|numeric|digits:10|unique:resellers,phone,'.$id.',id,deleted_at,NULL',
            'whatsapp_no'       => 'required|numeric|digits:10|unique:resellers,whatsapp_no,'.$id.',id,deleted_at,NULL',
            'address'           => 'required',
            'email'             => 'required|email|max:100|unique:resellers,email,'.$id.',id,deleted_at,NULL',
            'account_name'      => 'required|min:3|max:200',
            'account_number'    => 'required|regex:/^\d{9,18}$/|unique:resellers,account_number,'.$id.',id,deleted_at,NULL',
            'bank_name'         => 'required|min:3|max:200',
            'branch_name'       => 'required|min:3|max:200',
            'ifsc'              => 'required|regex:/^[A-Za-z]{4}\d{7}$/',
            'upi_id'            => 'required|regex:/^[\w.-]+@[\w.-]+$/'
        ];
        return $rules;
    }

}
