<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Validator;
use \Exception;
use App\Helpers\CommonHelper;
use App\Models\Route;
use App\Models\RouteServiceLocation;

class RouteController extends Controller
{
	     /**
	     * Http response data
	     */
	    private $data;

	    /**
	     * Http response code
	     */
	    private $code;

	    /**
	     * Response status
	     */
	    private $success;

	    /**
	     * Response message
	     */
	    private $message;

	    /**
	     * Init class attributes
	     */
	    public function __construct(Request $request)
	    {
	        $this->data     = new \stdClass();
	        $this->code     = Response::HTTP_OK;
	        $this->success  = true;
	        $this->message  = '';
	    }

    	/**
         * @param  Request
         * @return json
         */
        public function createRoute(Request $request)
        {
            $validator = Validator::make(
                $request->all(), 
                $this->createRouteRules(),
                (new CommonHelper())->getValidationMessage() 
            );
            if ($validator->fails()) 
            {
                $this->success  = false;
                $this->message  = $validator->errors()->first();
            }
            else
            {
                $route        = (new Route())->createRoute($request->all());
                if( !$route )
                {
                    $this->success  = false;
                    $this->message  = "Failed to create route.";
                }
                else
                { 
                	foreach ( explode(',', $request->delivery_locations) as $key => $location) 
                	{
                		(new RouteServiceLocation())->createRouteServiceLocation(['route_id' => $route->id , 'service_location_id' => $location]);
                	}
                	
                    $this->message  = "Route created successfully.";
                } 
            }
            // response
            return response()->json([
                'success'   => $this->success,
                'message'   => $this->message ,
                'data'      => $this->data
            ], $this->code);
        }

        /**
         * 
         * @author  RAHUL
        */ 
        public function updateRoute(Request $request)
        {
             $validator = Validator::make(
                $request->all(), 
                $this->updateRouteRules($request->id),
                (new CommonHelper())->getValidationMessage() 
            );
            if ($validator->fails()) 
            {
                $this->success  = false;
                $this->message  = $validator->errors()->first();
            }
            else
            {
            	$input = $request->all();
            	unset($input['delivery_locations']);
                (new Route())->updateRoute($input);
                // delete current locations
                (new RouteServiceLocation())->deleteRouteServiceLocationsByRouteId($request->id);
                // locations
                foreach ( explode(',', $request->delivery_locations) as $key => $location) 
            	{
            		(new RouteServiceLocation())->createRouteServiceLocation(['route_id' => $request->id , 'service_location_id' => $location]);
            	}


                $this->message = 'Route successfully updated';
            }
            
            return response()->json([
                    'success'   => $this->success,
                    'message'   => $this->message,
                    'data'      => $this->data
            ], $this->code);
        }

        /**
         * 
         * @author  RAHUL
        */
        public function deleteRoute(Request $request)
        {
            (new Route())->deleteRoute($request->id);
            return response()->json([
                    'success'   => $this->success,
                    'message'   => 'Route successfully deleted',
                    'data'      => $this->data
            ], $this->code);
        }

        /**
         * 
         * @author  RAHUL
        */
        public function getSingleRoute(Request $request)
        {
            $this->data = [ 'route' =>(new Route())->getRouteById($request->id)];
            return response()->json([
                    'success'   => $this->success,
                    'message'   => 'Route successfully fetched',
                    'data'      => $this->data
            ], $this->code);
        }

        /**
         * get all user category list
         * @author  RAHUL
        */
        public function getRouteList(Request $request)
        {

            $result         =  (new Route())->getRouteList($request);
            $this->data     =  [    'results' =>  $result ,
                                    'link' =>  (string) $result->links() 
                                ];
            return response()->json([
                    'success'   => $this->success,
                    'message'   => 'Route successfully retrieved',
                    'data'      => $this->data
            ], $this->code);
        }

        /**
         * 
         * 
         */
        public function createRouteRules()
        {
            return [
                'name'              	=> 'required',
                'delivery_boy_id'   	=> 'required',
                'delivery_locations'    => 'required',
                
            ];
        }

        /**
         * 
         * 
         */
        public function updateRouteRules( $id )
        {
            return [
                'name'              	=> 'required',
                'delivery_boy_id'   	=> 'required',
                'delivery_locations'    => 'required',
            ];
        }

}
