<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Http\Response;
use App\Models\Slider;
use Validator;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Storage;

class SliderController extends Controller
{
  /**
     * Http response data
     */
    private $data;

    /**
     * Http response code
     */
    private $code;

    /**
     * Response status
     */
    private $success;

    /**
     * Response message
     */
    private $message;

    /**
     * Init class attributes
     */
    public function __construct(Request $request)
    {
        $this->data     = new \stdClass();
        $this->code     = Response::HTTP_OK;
        $this->success  = true;
        $this->message  = '';
    }

    public function getSliderIndex(Request $request)
    {

        return view('admin.slider.list');
    }

    /**
     * get all slider list
     * @author  SOORYA
    */
    public function getSliderList(Request $request)
    {
        $result = (new Slider())->getAdminSliderList($request) ;
        $this->data  = [    'results' =>  $result ,
                            'link' =>  (string) $result->links() 
                        ];
        return response()->json([
                'success'   => $this->success,
                'message'   => 'Slider list successfully retrieved',
                'data'      => $this->data
        ], $this->code);
    }

    public function create(Request $request)
    {
        return view('admin.slider.create');
    }

    public function createSlider(Request $request)
    {
         $validation = Validator::make($request->all(), [
             'title'                  => 'required',
             'description'            => 'required',
             'image'                  => 'required|image|mimes:jpeg,png,jpg'
         ]) ;
        if(!$validation->passes())
        {
          return response()->json([
                'success'   => false,
                'message'   => $validation->errors()->first() ,
                'data'      => $this->data
            ], $this->code);
        }
        if($request->file('image'))
        {
            $file      =  $request->file('image');
            $extension = $file->extension();
            $file_name = implode('_', [
                    date('YmdHis'),
                    Str::slug($request->name,'_image')
                ]);
    
            $path      = 'images/slider/';
            Storage::disk('local')->putFileAs('public/'.$path, $file,$file_name .'.'. $extension);
            $image      = '/storage/'.$path. $file_name .'.'. $extension;

        }

        (new Slider())->createSlider([
            'title'                 => $request->title,
            'description'           => $request->description,
            'image'                 => $image,
        ]);

        $request->session()->flash('message', 'Slider successfully Created'); 
        $request->session()->flash('alert-class', 'alert-success'); 
        return redirect('/admin/slider');

    }

    public function edit(Request $request)
    {
        $slider = Slider::find(base64_decode($request->id));
        return view('admin.slider.edit',['slider' => $slider]);
    }

    public function update(Request $request)
    {
         $validation = Validator::make($request->all(),
          [
            'title'                  => 'required',
            'description'            => 'required'
         ]) ;
        if(!$validation->passes())
        {
          return response()->json([
                'success'   => false,
                'message'   =>  $validation->errors()->first() ,
                'data'      => $this->data
            ], $this->code);
        }

        $input = [
            'title'                 => $request->title,
            'description'           => $request->description
        ]; 

        if($request->file('image'))
        {
            $file               =  $request->file('image');
            $extension          = $file->extension();
            $file_name          = implode('_', [
                                    date('YmdHis'),
                                    Str::slug($request->name,'_image')
                                ]);
    
            $path               = 'images/slider/';
            Storage::disk('local')->putFileAs('public/'.$path, $file,$file_name .'.'. $extension);
            $input['image']      = '/storage/'.$path. $file_name .'.'. $extension;

        }

        (new Slider())->updateSlider($request->id, $input );


        return redirect('/admin/slider');

    }

    public function deleteSlider(Request $request)
    {
        (new Slider())->deleteSlider($request->id);
        return response()->json([
                'success'   => $this->success,
                'message'   => 'Slider successfully deleted',
                'data'      => $this->data
        ], $this->code);
    }
}
