<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Validator;
use Exception;
use App\Helpers\CommonHelper;
use App\Helpers\PushNotificationHelper;
use Auth;
use App\Store;
use App\User;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Storage;
use Illuminate\Hashing\BcryptHasher;


class UserController extends Controller
{
    

     /**
     * Http response data
     */
    private $data;

    /**
     * Http response code
     */
    private $code;

    /**
     * Response status
     */
    private $success;

    /**
     * Response message
     */
    private $message;

    /**
     * Init class attributes
     */
    public function __construct(Request $request)
    {
        $this->data     = new \stdClass();
        $this->code     = Response::HTTP_OK;
        $this->success  = true;
        $this->message  = '';
        $this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function storeProfile()
    {

        return view('store.profile',['user'=>Auth::user()]);
    }

    public function updateProfile(Request $request)
    {
         $validator = Validator::make(
            $request->all(), 
            $this->updateStoreRules($request->id),
            (new CommonHelper())->getValidationMessage() 
        );
        if ($validator->fails()) 
        {
            $this->success  = false;
            $this->message  = $validator->errors()->first();
        }
        else
        {

            $input = $request->all();
            if($request->hasFile('logo'))
            {
                $file =  $request->file('logo');
                $extension = $file->extension();
                $file_name = implode('_', [
                        date('YmdHis'),
                        Str::slug($request->name,'_')
                    ]);

                $path = 'images/logo/';
                Storage::disk('local')->putFileAs('public/'.$path, $file,$file_name .'.'. $extension);
                $input['logo']     = '/storage/'.$path. $file_name .'.'. $extension;
            }

            (new Store())->updateStore($input);
            $this->message = 'Profile successfully updated';
        }
        
        return response()->json([
                'success'   => $this->success,
                'message'   => $this->message,
                'data'      => $this->data
        ], $this->code);

    }

    public function updatePassword(Request $request)
    {
         $validator = Validator::make(
            $request->all(), 
            $this->updatePasswordRules($request->id),
            (new CommonHelper())->getValidationMessage() 
        );
        if ($validator->fails()) 
        {
            $this->success  = false;
            $this->message  = $validator->errors()->first();
        }
        else
        {

            $input['id'] = $request->id;
            $input['password']    = (new BcryptHasher)->make($request->password);  
            (new Store())->updateStore($input);
            $this->message = 'Password successfully updated';
        }
        
        return response()->json([
                'success'   => $this->success,
                'message'   => $this->message,
                'data'      => $this->data
        ], $this->code);
    }

    /**
     * 
     * 
     */

    public function userNotification()
    {
        $title        = "bizi gggggggggggggggggggggggg";
        $body         = "bizi-content gggggggggggggggg";
        $device       = "fibor_hVSSWNtwS-SAnNVL:APA91bEJnaW-mUp17DaDKLWxgfNmc5oG6elU6U7Ppcsh1xYwrUcg_GvV5-pDfxgpg_AjO3pgE95fF6SwSqIQ4mJw-fJi8QMg-0uWLEEth-4LEWn_ax-nMknEHeij6QT2GvdBJvvmmtwB";
        $notification = 1;

        $this->data = (new PushNotificationHelper)->sendUserNotification($device,$title,$body,$notification);

        $this->message = 'successfully completed';

        return response()->json([
            'success'   => $this->success,
            'message'   => $this->message,
            'data'      => $this->data
        ], $this->code);
       
    }

    //

    public function deliveryNotification()
    {
        $title        = "bizi hfffffffffffffff";
        $body         = "bizi-content trrrrrrrrrrrrrrrrr";
        $device       = "c73LOFWzQgCbEdK-CyxLKf:APA91bFNC1XbxwzxHz1bFxSKzSsRtEFVmPY-BqoEnA_YC2SCnoxNyYq7ly_IwO0oaSeGIEERr0CH-3iNO_ZYv7grqbJ-7p0X4gY3onMke3Vim6VEXS-Ul31Lb3VncOBIt577uU5QjzZ3";
        $notification = 1;

        $this->data = (new PushNotificationHelper)->sendDeliveryNotification($device,$title,$body,$notification);

        $this->message = 'successfully completed';

        return response()->json([
            'success'   => $this->success,
            'message'   => $this->message,
            'data'      => $this->data
        ], $this->code);
       
    }

    public function getUsers(Request $request)
    {
        $this->data         = (new User())->getUser($request->service_location_id);
        return response()->json([
            'success'   => $this->success,
            'message'   => 'Users Fetched',
            'data'      => $this->data
        ], $this->code);
    }

    //

    public function updateStoreRules($id)
    {
        return [
            'pincode'           => 'required|exists:service_locations,pincode',
            'name'              => 'required|min:3|max:200',
            'phone'             => 'required|numeric|digits_between:10,12|unique:stores,phone,'.$id.',id,deleted_at,NULL',
            'email'             => 'required|email|max:100|unique:stores,email,'.$id.',id,deleted_at,NULL',
            
            ];
    }

    public function updatePasswordRules()
    {
        return [
                'password'          => 'required_with:confirm_password|min:8|max:20',
                'confirm_password'  => 'same:password|required|min:8|max:20',
            ];
    }
}
