<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Http\Response;
use App\Models\Vendor;
use App\Models\Reseller;
use App\Models\UserDevice;
use Illuminate\Hashing\BcryptHasher;
use App\User;
use Validator;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Carbon;
use App\Jobs\UserPushNotificationAndMessage;

class VendorController extends Controller
{
            /**
     * Http response data
     */
    private $data;

    /**
     * Http response code
     */
    private $code;

    /**
     * Response status
     */
    private $success;

    /**
     * Response message
     */
    private $message;

    /**
     * Init class attributes
     */
    public function __construct(Request $request)
    {
        $this->data     = new \stdClass();
        $this->code     = Response::HTTP_OK;
        $this->success  = true;
        $this->message  = '';
    }
    
        /**
     * @param  Request
     * @return json
     */
    public function create(Request $request)
    {
        $this->user       = null;
        if($request->user)
        {
            $this->user   = $request->user;
            $users        = User::where('id',$request->user)
                                ->orderBy('id','ASC')
                                ->get();
        }
        else
        {
            $users        = [];
        }
        $users = User::where('is_vendor',null)->get();
        return view('admin.vendor.create',[
            'users'       => $users,
            'user'        => $this->user
            ]);
    }   
    public function createVendor(Request $request)
    {
        if($request->user == '')
        {
        $rules              = $this->createVendorRules();
        $this->validate($request, $rules);

            $password           = $request->password;
            $hashed_password    = (new BcryptHasher)->make($request->password);      
            $user               = (new User())->createNewUser([
                'name'          => trim( ucfirst($request->name)),
                'address'       => trim( $request->address),
                'is_active'     => $request->is_active,
                'email'         => trim( $request->email),
                'phone'         => trim( $request->phone),
                'role_id'       => 2,
                'password'      => $hashed_password,
                'is_vendor'     => Carbon::now()->format('Y-m-d H:i:s')
            ]);  
            if($user)
            {
                $vendor           = (new Vendor())->createVendor($request, $user->id);
                if( !$vendor )
                {
                    $this->success  = false;
                    $this->message  = "Failed to create vendor.";
                }
                else
                { 
                    $this->message  = "Vendor created successfully.";
                } 
            }
            
            // response
            $request->session()->flash('message', 'Vendor created successfully.'); 
            $request->session()->flash('alert-class', 'alert-success'); 
            return redirect('/admin/vendor');
        }
        else
        {
            $rules              = $this->createNewVendorRules();
            $this->validate($request, $rules);

            $user                  = (new User())->getUserById($request->user);
            $update_user           = (new User())->createNewUserVendor($request,$user->id);

            if($user)
            {
                $vendor           = (new Vendor())->createVendor($request, $user->id);
                if( !$vendor )
                {
                    $this->success  = false;
                    $this->message  = "Failed to create vendor.";
                }
                else
                { 
                    $this->message  = "Vendor created successfully.";
                } 
            }

            // response
            $request->session()->flash('message', 'Vendor created successfully.'); 
            $request->session()->flash('alert-class', 'alert-success'); 
            return redirect('/admin/vendor');
        }
      
    }

    /**
     * @param  Request
     * @return json
     * @author PMS
     */
    public function getVendorList(Request $request)
    {
        $result         =  (new Vendor())->getVendorList($request);
        $this->data     =  [    'results' =>  $result ,
                                'link' =>  (string) $result->links() 
                            ];
        return response()->json([
                'success'   => $this->success,
                'message'   => 'Vendors successfully retrieved',
                'data'      => $this->data
        ], $this->code);
    }

    /**
     * 
     * 
     */
    public function getUnapprovedVendorList(Request $request)
    {
        $result         =  (new Vendor())->getUnapprovedVendorList($request);
        $this->data     =  [    'results' =>  $result ,
                                'link' =>  (string) $result->links() 
                            ];
        return response()->json([
                'success'   => $this->success,
                'message'   => 'Unapproved Vendors successfully retrieved',
                'data'      => $this->data
        ], $this->code);
    }

    /**
     * 
     * 
     */
    public function editVendor(Request $request)
    {
        $vendor         = (new Vendor())->getSingleVendor(base64_decode($request->id));
        return view('admin.vendor.edit',['vendor' => $vendor]);
    }

    /**
     * 
     * 
     */

    public function updateVendor(Request $request)
    {
        $rules                 = $this->updateVendorRules($request->id);
        $this->validate($request,$rules);
        
        $vendor                  = (new Vendor())->getSingleVendor($request->id);
        $update_vendor           = (new Vendor())->updateVendor($request,$vendor->id);
        if( !$update_vendor)
        {
            $this->success  = false;
            $this->message  = "Failed to update vendor.";
        }
        else
        { 
            $this->message  = "Vendor updated successfully.";
        } 
        
        // response
        $request->session()->flash('message', 'Vendor updated successfully.'); 
        $request->session()->flash('alert-class', 'alert-success'); 
        return redirect('/admin/vendor');
        
    }

    /**
     * 
     * 
     */

    public function delVendor(Request $request)
    {
        (new Item())->delVendorItems($request->id);
        (new Vendor())->delVendor($request->id);
        return response()->json([
                'success'   => $this->success,
                'message'   => 'Vendor successfully deleted',
                'data'      => $this->data
        ], $this->code);
    }

    public function updateVendorStatus(Request $request)
    {
        $change_status       = (new Vendor())->changeStatus($request->id);
        
        return response()->json([
            'success'   => $this->success,
            'message'   => 'Vendor Status Updated',
            'data'      => $this->data
        ], $this->code);
    }

    public function updateVendorApproveStatus(Request $request)
    {
        $change_approve_status       = (new Vendor())->changeApproveStatus($request->id);
        $vendor                      = (new Vendor())->getApproveStatus($request->id);
        if($vendor)
        {
            $user  = (new User())->getUserById($vendor->user_id);
            if(isset($user))
            {   
                $reseller  = (new Reseller())->getResellerByUserId($user->id);
                if(isset($reseller))
                {
                    $template_id    = 1207163479593737267;
                    $message        = "Vendor Approved!";
                    $title          = "Vendor Approved!";
                    $description    = "Vendor Approved!";
                    $firebase_token     =  (new UserDevice())->userFirebaseTokenList($reseller->user->id);

                    UserPushNotificationAndMessage::dispatch($reseller->user->phone,$firebase_token, $message, $title,  $description, $template_id);
                }
            }
        }
        return response()->json([
            'success'   => $this->success,
            'message'   => 'Vendor Approved',
            'data'      => $this->data
        ], $this->code);
    }

    public function getResellerDetails(Request $request)
    {
        $user = (new User())->getReseller($request);
        $this->data = $user;
        return response()->json([
            'success'   => $this->success,
            'message'   => 'user successfully retrieved',
            'data'      => $this->data
        ], $this->code);

    }
    public function createVendorRules()
    {
        $rules =  [
            'pincode'           => 'required|digits:6',
            'name'              => 'required|min:3|max:200',
            'phone'             => 'required|numeric|digits:10|unique:vendors,phone,NULL,id,deleted_at,NULL',
            'whatsapp_no'       => 'required|numeric|digits:10|unique:vendors,whatsapp_no,NULL,id,deleted_at,NULL',
            'address'           => 'required',
            'email'             => 'required|email|max:100|unique:vendors,email,NULL,id,deleted_at,NULL',
            'gst'               => 'nullable|regex:/\d{2}[A-Z]{5}\d{4}[A-Z]{1}[A-Z\d]{1}[Z]{1}[A-Z\d]{1}/',
            'account_name'      => 'required|min:3|max:200',
            'account_number'    => 'required|regex:/^\d{9,18}$/|unique:vendors,account_number,NULL,id,deleted_at,NULL',
            'bank_name'         => 'required|min:3|max:200',
            'branch_name'       => 'required|min:3|max:200',
            'ifsc'              => 'required|regex:/^[A-Za-z]{4}\d{7}$/',
            'upi_id'            => 'required|regex:/^[\w.-]+@[\w.-]+$/',
            'password'          => 'required_with:confirm_password|min:6|max:20',
            'confirm_password'  => 'same:password|required|min:6|max:20'
            
        ];
        return $rules;
    }

    public function createNewVendorRules()
    {
        $rules =  [
            'pincode'           => 'required|digits:6',
            'name'              => 'required|min:3|max:200',
            'phone'             => 'required|numeric|digits:10|unique:vendors,phone,NULL,id,deleted_at,NULL',
            'whatsapp_no'       => 'required|numeric|digits:10|unique:vendors,whatsapp_no,NULL,id,deleted_at,NULL',
            'address'           => 'required',
            'email'             => 'required|email|max:100|unique:vendors,email,NULL,id,deleted_at,NULL',
            'gst'               => 'nullable|regex:/\d{2}[A-Z]{5}\d{4}[A-Z]{1}[A-Z\d]{1}[Z]{1}[A-Z\d]{1}/',
            'account_name'      => 'nullable|min:3|max:200',
            'account_number'    => 'nullable|regex:/^\d{9,18}$/|unique:vendors,account_number,NULL,id,deleted_at,NULL',
            'bank_name'         => 'nullable|min:3|max:200',
            'branch_name'       => 'nullable|min:3|max:200',
            'ifsc'              => 'nullable|regex:/^[A-Za-z]{4}\d{7}$/',
            'upi_id'            => 'nullable|regex:/^[\w.-]+@[\w.-]+$/'
            
        ];
        return $rules;
    }

    public function updateVendorRules($id)
    {
        $rules =  [
            'pincode'           => 'required|digits:6',
            'name'              => 'required|min:3|max:200',
            'phone'             => 'required|numeric|digits:10|unique:vendors,phone,'.$id.',id,deleted_at,NULL',
            'whatsapp_no'       => 'required|numeric|digits:10|unique:vendors,whatsapp_no,'.$id.',id,deleted_at,NULL',
            'address'           => 'required',
            'email'             => 'required|email|max:100|unique:vendors,email,'.$id.',id,deleted_at,NULL',
            'gst'               => 'nullable|regex:/\d{2}[A-Z]{5}\d{4}[A-Z]{1}[A-Z\d]{1}[Z]{1}[A-Z\d]{1}/',
            'account_name'      => 'nullable|min:3|max:200',
            'account_number'    => 'nullable|regex:/^\d{9,18}$/|unique:vendors,account_number,'.$id.',id,deleted_at,NULL',
            'bank_name'         => 'nullable|min:3|max:200',
            'branch_name'       => 'nullable|min:3|max:200',
            'ifsc'              => 'nullable|regex:/^[A-Za-z]{4}\d{7}$/|unique:vendors,ifsc,'.$id.',id,deleted_at,NULL',
            'upi_id'            => 'nullable|regex:/^[\w.-]+@[\w.-]+$/'
        ];
        return $rules;
    }

    public function updatePasswordRules()
    {
        $rules = [
            'password'          => 'required_with:confirm_password|min:6|max:20',
            'confirm_password'  => 'same:password|required|min:6|max:20'
        ];
        return $rules;
    }
  
}
