<?php
namespace App\Jobs;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use App\Helpers\PushNotificationHelper;
class DeliveryBoyNotifications implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;
    private $title;
    private $message;
    private $firebase_token;
    private $notification_type;


    /**
     * Create a new job instance.
     *
     * @return void
     */
    public function __construct($title,$message,$firebase_token,$type)
    {
        $this->title                = $title;
        $this->message              = $message;
        $this->firebase_token       = $firebase_token;
        $this->notification_type    = $type;
    }
    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {
        if($this->title && $this->message && $this->firebase_token)
        {
            (new PushNotificationHelper())->sendDeliveryBoySingleNotification($this->title,$this->message,$this->firebase_token,$this->notification_type);
        }
    }
}
