<?php
namespace App\Jobs;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use App\Helpers\SmsHelper;
class UserMessage implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;
    private $phone;
    private $message;
    private $template_id;


    /**
     * Create a new job instance.
     *
     * @return void
     */
    public function __construct($phone,$message,$template_id)
    {
        $this->phone                = $phone;
        $this->message              = $message;
        $this->template_id          = $template_id;
    }
    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {
        if($this->phone && $this->message)
        {
            (new SmsHelper())->sendSmsMessage($this->phone,$this->message,$this->template_id);
        }
    }
}
