<?php

namespace App\Jobs;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use App\Helpers\PushNotificationHelper;

class UserMultiplePushNotification implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    private $users;
    private $device_ids;
    private $title;
    private $content;
    private $notification_id;
    private $image;
    /**
     * Create a new job instance.
     *
     * @return void
     */
    public function __construct($users,$device_ids,$title,$content,$notification_id,$image)
    {
        $this->users            = $users;
        $this->device_ids       = $device_ids;
        $this->title            = $title;
        $this->content          = $content;
        $this->notification_id  = $notification_id;
        $this->image            = $image;

    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {  
        if($this->users && $this->title && $this->content)
        {
            (new PushNotificationHelper())->sendMultipleUserNotification($this->users,$this->device_ids,$this->title,$this->content,$this->notification_id,$this->image);
        }
    }
}
