<?php
 
namespace App\Models;
 
use App\User;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;
 
class Audit extends Model
{
 
    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
         'method', 'path', 'query', 'userAgent', 'ip', 'device' , 'platform', 'browser' , 'isDesktop', 'isMobile' , 'isPhone' , 'isTablet','user_id'
    ];
 
    protected $appends = ['device'];

 
    public function user ()
    {
        return $this->belongsTo(User::class);
    }
 
    public function getDeviceAttribute ()
    {
        $device = '';
        if($this->isDesktop == 1){
            $device = 'Desktop';
        }else  if($this->isMobile == 1){
            $device = 'Mobile';
        }else  if($this->isPhone == 1){
            $device = 'Phone';
        } else  if($this->isTablet == 1){
            $device = 'Tablet';
        }
        return $device;
    }
 
 
    /**
     * Get online users
     *
     * @param int $min
     * @return \Illuminate\Database\Eloquent\Collection|static[]
     */
    public function online ($min = 3)
    {
 
        return $this->select('user_id')
                    ->where('audits.created_at', '>=', Carbon::now()->subMinutes($min)->toDateTimeString())
                    ->distinct('user_id')
                    ->with('user')
                    ->get()->map(function ($item) {
                        return $item->user;
                    });
 
    }
}