<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Authors extends Model
{
    use HasFactory;
    use SoftDeletes;

    protected $fillable = [
        'name',
        'bio',
        'image'
    ];

    /**
     * The attributes excluded from the model's JSON form.
     *
     * @var array
     */
    protected $hidden = [
        'created_at',
        'updated_at',
        'deleted_at'
    ];



    public function getAdminAuthorsList($request)
    {
        return self::select('id', 'name', 'bio', 'image')->paginate($request->limit);
    }

    public function saveData($input)
    {
        return self::create($input);
    }

    public function deleteAuthor($id)
    {
        return self::where('id', $id)->delete();
    }

    public function getSingleAuthor($id)
    {
        return self::where('id', $id)->first();
    }

    public function updateAuthor($id, $data)
    {
        return self::where('id', $id)->update($data);
    }

    public function getAuthorsList()
    {
        return self::all();
    }
}
