<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Model;

class Banner extends Model
{
    use SoftDeletes;
    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'name','image','mobile_banner','priority','link'
    ];

    /**
     * The attributes excluded from the model's JSON form.
     *
     * @var array
     */
    protected $hidden = [
        'created_at','updated_at','deleted_at'
    ];

    /**
    * 
    * @return void
    */

    public function category()
    {
        return $this->belongsTo('App\Models\Category');
    }


    /**
    * 
    * @return void
    */
    //  public function getImageAttribute($value)
    // {
    //    return url("/").$value;
    // }

    /**
    * 
    * @return void
    */

    /**
     * 
     * 
     */
    public function getBannerImageById($id)
    {
       return self::where('id', $id)->first();
    }


    public function createBanner($input)
    {
    	return self::create($input);
    }

     /**
     * 
     * 
     */
    public function updateBannerImage($id,$data)
    {
       return self::where('id', $id)
                    ->update($data);
    }



    public function bannerDelete($id)
    {
    	return self::where('id',$id)->delete();
    }
    /**
    * 
    * @return void
    */
    public function getBannerImageList($request)
    {

        $query =  self::where('deleted_at',NULL)->with('category:id,name');
        if( isset($request->search) && !empty($request->search))
        {
            $query = $query->where("name",'LIKE','%'.$request->search.'%');
        }
        return $query->paginate($request->limit);
    }

    public function getBanner()
    {
    	return self::all();
    }

    public function getUserBanner()
    {
        return self::select('name','image','category_id','offer_content')
        ->where('deleted_at',NULL)
        ->get();
    }


    public function getBannerList()
    {
        return self::select('id','name','image','mobile_banner','link')
        ->where('deleted_at',NULL)
        ->get();
    }


}
