<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Support\Facades\DB;

class Cart extends Model
{
    use SoftDeletes;

    const CREATED_AT = 'created_at';
    const UPDATED_AT = 'updated_at';

    /**
     * fillable colums
     *
     * @var array
     */
    protected $fillable = [
        'reseller_id',
        'item_id',
        'vendor_id',
        'quantity',
        'is_available'
    ];

    /**
     * The attributes excluded from the model's JSON form.
     *
     * @var array
     */
    protected $hidden = [
        'deleted_at','created_at','updated_at'
    ];
   
    /**
    * 
    * @return void
    */
    public function reseller()
    {
        return $this->belongsTo('App\Models\Reseller','reseller_id','id');
    }

    public function vendor()
    {
        return $this->belongsTo('App\Models\Vendor','vendor_id','id');
    }

        /**
    * 
    * @return void
    */
    public function product()
    {
        return $this->belongsTo('App\Models\Item','item_id','id');
    }


   
    /**
     * add products to user cart
     * @author  Rahul
     * 
     */
    public function createCart($input)
    {
        return self::create($input);
    }

     /**
     * 
     * @author  RAHUL
     * 
     */
    public function updateCart($id , $input)
    {
        return self::where('id',$id)->update($input);
        
    }

    

     /**
     * get cart details by cart_id
     * @author  Rahul
     * 
     */
    public function getCartByID($id)
    {
        return self::with('userAddress')
        ->where('id', $id)
        ->get();
    }

  
    /**
     * 
     * @author  RAHUL
     * 
     */
    public function getCartByUserId($reseller_id)
    {
         return self::with('product')
            ->where('reseller_id', $reseller_id)
            ->first();
    }

    public function cartCount($reseller_id)
    {
       return self::where('reseller_id',$reseller_id)->count();
    }
    /**
     * @author  RAHUL
     */
    public function getAllProductsInCart($reseller_id)
    {
          return self::with('product','vendor:id,name')
            ->where('reseller_id', $reseller_id)
            ->get();
    }

    /**
     * 
     * @author  RAHUL
     * 
     */
    public function getUserCart($reseller_id)
    {
          return self::where('reseller_id',$reseller_id)->get();
    }

    /**
     * 
     * @author  AJMAL
     * 
     */
    public function getUserCarts($reseller_id)
    {
          return self::where('reseller_id',$reseller_id)->where('is_available',true)->get();
    }

    

    /**
     * 
     * @author  RAHUL
     * 
     */
    public function deleteCart($id)
    {
          return self::where('id', $id)->delete();
    }

     /**
     * 
     * @author  RAHUL
     * 
     */
    public function clearAllCart($reseller_id)
    {
        return self::where('reseller_id', $reseller_id)->delete();
    }

    public function getUserProductCartQuantity($reseller_id , $item_id)
    {

        return self::where('reseller_id', $reseller_id)->orWhere('item_id', $item_id)->sum('quantity');
    }

   

    /**
     * delete cart details
     * 
     * @author Rahul
     *
     * @param [type] $request
     * @return void
     */
    public function deleteCartById($id)
    {
        return self::where('id', $id)
        ->delete();
    }

    /**
     * 
     * @author  Rahul
     * 
     */
    public function getCartProductsByUserId($reseller_id)
    {
        return self::select('product')
        ->where('reseller_id', $reseller_id)
        ->first();
    }

    public function getUserProductInCart($reseller_id , $item_id, $vendor_id)
    {
        return self::where('item_id', $item_id)->where('reseller_id',$reseller_id)->where('vendor_id',$vendor_id)->first();
    }

    public function getItemQuantity($item_id,$reseller_id)
    {
        return self::select(DB::raw('sum(quantity) as quantity'))
        ->groupBy('item_id')
        ->where('item_id',$item_id)
        ->where('reseller_id',$reseller_id)
        ->first();
    }
}

