<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Contact extends Model
{


 	use SoftDeletes;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'user_id','subject','message','status','role_id','phone'
    ];

        /**
     * The attributes excluded from the model's JSON form.
     *
     * @var array
     */
    protected $hidden = [
        'created_at','updated_at','deleted_at'
    ];
   
   /**
    * 
    * @return void
    */
    public function user()
    {
        return $this->belongsTo('App\Models\User');
    }

  	public function createContact($input)
  	{
  		return self::create($input);
  	}

  	public function getUserContactUsList($request)
  	{
  		$query =   self::with('user')
                ->whereHas('user',function($q){
                  $q->where('role_id',2);
                })->orderBy('status','asc');

        if( isset($request->search) && isset($request->search))
        {
             $query->where('subject','LIKE','%'.$request->search.'%');
             $query->orWhere('message','LIKE','%'.$request->search.'%');
        }
        return   $query->latest()->paginate($request->limit);
  	}

    public function getUserContacts()
    {
      return self::with('user')->where('role_id',1)->where('status',0)->limit(2)->get();
    }


    public function changeStatus($id)
    {
        $user =  self::where('id',$id)->first();
        if($user->status == 0)
        {
            return self::where('id',$id)->update(['status' => 1]);
        }
    }

    /**
     * 
     * 
     */
    public function createContactRequest($request)
    {
      return self::create([
        'user_id'   => $request->user_id,
        'subject'   => $request->subject,
        'message'   => $request->message,
        'status'    => $request->status
      ]);
    }
}
