<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Coupon extends Model
{
    use SoftDeletes;

    protected $fillable = [

        'name',
        'code',
        'expiry_date',
        'minimum_order',
        'discount_percentage',
        'discount_amount',
        'total_count',
        'remaining_count',
        'is_active'


    ];

    public function updateCoupons($request,$id)
    {
       
        $data = [

                'name'                      => $request->name,
                'code'                      => $request->code,
                'expiry_date'               => $request->expiry_date,
                'minimum_order'             => $request->minimum_order,
                'discount_percentage'       => $request->discount_percentage,
                'discount_amount'           => $request->discount_amount,
                'total_count'               => $request->total_count,
                'remaining_count'           => $request->total_count,
                'is_active'                 => $request->is_active
        ];
      
       
        return self::where('id',$id)->update($data);
    }

    public function createCoupons($input)
    {
        return self::create($input);
    }

    public function getCouponId($id)
    {
        return self::find($id);
    }

    public function getCoupon($code)
    {
        return self::where('code',$code)->where('is_active',1)->where('expiry_date','>=',date('Y-m-d'))->first();
    }
    
    public function deleteCoupon($id)
    {
        return self::where('id',$id)->delete();    
    }

    public function getCouponList($request)
    {
        $query =  self::where('deleted_at',NULL);
        if( isset($request->search) && !empty($request->search))
        {
            $query = $query->where("name",'LIKE','%'.$request->search.'%');
        }
        return $query->paginate($request->limit);
    }
    /**
     * 
     */
    public function updateCouponData($data,$id)
    {
        return self::where('id',$id)->update($data);
    }
    /**
     * 
     * 
     */
    public function getCoupons()
    {
        return self::select(
            'id',
            'name',
            'code',
            'expiry_date',
            'minimum_order',
            'discount_percentage',
            'discount_amount',
            'total_count',
            'remaining_count',
            'is_active'
        )
        ->where('is_active',1)
        ->get();
    }


}
