<?php

namespace App\Models;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class CouponRedeemedUser extends Model
{
    use SoftDeletes;
    protected $fillable = ['order_id','coupon_id','user_id'];

    /**
     * 
     */
    public function order()
    {
        return $this->belongsTo('App\Models\Order');
    }

    public function user()
    {
        return $this->belongsTo('App\Models\User');
    }

    public function coupon()
    {
        return $this->belongsTo('App\Models\Coupon');
    }

    public function createData($data)
    {
        return self::create($data);
    }

    public function getUsers($coupon_id)
    {
        return self::where('coupon_id',$coupon_id)->get(); 
    }
       
    public function getCouponUsersList($coupon_id)
    {

        $query =  self::where("deleted_at",null)
                      ->where("coupon_id",$coupon_id)
                      ->with('order:id,invoice_number','user:id,name');
                       
      
        return $query->paginate(10);
    }
}
