<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class DeliveryPartner extends Model
{
    use SoftDeletes;

    protected $fillable = [
        'name',
        'address',
        'link'
    ];

    protected $hidden = [
        'created_at',
        'updated_at',
        'deleted_at'
    ];

    public function getDeliveryPartnersList($request)
    {
        return self::paginate($request->limit);
    }

    public function getDeliveryPartners()
    {
        return self::all();
    }

    public function createDeliveryPartner($data)
    {
        return self::create($data);
    }

    public function updateDeliveryPartner($id, $data)
    {
        return self::where('id',$id)->update($data);
    }

    public function deleteDeliveryPartner($id)
    {
        return self::where('id',$id)->delete();
    }   
    public function getDeliveryParnerById($id)
    {
        return self::find($id);
    }
}
