<?php

namespace App\Models;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Model;

class OrderResponse extends Model
{
    use SoftDeletes;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'order_uuid',
        'order_id',
        'user_id',
        'is_success',
        'response',
        'store_id',
        'payment_gateway_referance'
    ];

    /**
     * The attributes excluded from the model's JSON form.
     *
     * @var array
     */
    protected $hidden = [
        'created_at','updated_at','deleted_at'
    ];



    /**
    *
    *
    */
    public function createOrderResponse($input)
    {
        return self::create($input);
    }

    public function getOrderResponseByTempId($order_uuid)
    {
        return self::where('order_uuid', $order_uuid)->first();
    }

    public function updateOrderResponse($id , $input)
    {
        return self::where('id', $id)->update($input);
    }
}
