<?php

namespace App\Models;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Model;

class OrderStatus extends Model
{
    use SoftDeletes;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'name',
    ];

    /**
     * The attributes excluded from the model's JSON form.
     *
     * @var array
     */
    protected $hidden = [
        'created_at','updated_at','deleted_at'
    ];

    public function getOrderStatuses()
    {
        return self::get();
    }

    public function getIncompleteOrderStatuses()
    {
        return self::whereIn('id',[2,4,8])->get();
    }
    
    public function getOrderStatusById()
    {
        return self::get();
    }
}
