<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Pincode extends Model
{
    use SoftDeletes;
    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'pincode','address','city_id','state_id'
    ];

    /**
     * The attributes excluded from the model's JSON form.
     *
     * @var array
     */
    protected $hidden = [
        'created_at','updated_at','deleted_at'
    ];

     /**
    * 
    * @return void
    */
    public function city()
    {
        return $this->belongsTo('App\City','city_id','id');
    }

     /**
    * 
    * @return void
    */
    public function state()
    {
        return $this->belongsTo('App\State','state_id','id');
    }

    public function getPincodeById($id)
    {
        return self::find($id);
    }    

    /**
    * 
    * @return void
    */
    public function createPincode($request)
    {
       return self::create([
            'pincode'       => $request->pincode,
            'address'       => $request->address,
            'city_id'       => $request->city_id,
            'state_id'      => $request->state_id
        ]);
    }
    public function updatePincode($request)
    {
       return self::where('id', $request->id)
            ->update([
                        'pincode'       => $request->pincode,
                        'address'       => $request->address,
                        'city_id'       => $request->city_id,
                        'state_id'      => $request->state_id
                   ]);
    }

    public function getPincodeList($request)
    {
        $query =  self::with('city','state')->where('deleted_at',NULL);
        if( isset($request->search) && !empty($request->search))
        {
            $query = $query->where("pincode",'LIKE','%'.$request->search.'%');
        }
        return $query->paginate($request->limit);
    }

}
