<?php

namespace App\Models;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Model;
use Auth;

class ProductDeliveryCharge extends Model
{
    use SoftDeletes;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'state_id','item_id','delivery_charge'
    ];

    /**
     * The attributes excluded from the model's JSON form.
     *
     * @var array
     */
    protected $hidden = [
        'created_at','updated_at','deleted_at'
    ];
    /**
     * 
     * 
     * 
     */
    public function products()
    {
        return $this->hasMany('App\Models\Item');
    }

    public function state()
    {
        return $this->belongsTo('App\State');
    }

    public function getProductDeliveryCharge($id)
    {
        return self::with('state')->where('id',$id)->first();
    }

    public function createDeliveryCharge($request,$item,$State)
    {
        $data          = [];
        foreach($request->state_id as $state_id)
        {
            $data = self::create([
                'item_id'         => $request->id,
                'state_id'        => (int)$state_id,
                'delivery_charge' => $request->delivery_charge
            ]);
        }
        return $data;
    }

    public function addDeliveryCharge($request)
    {
        $data          = [];
        foreach($request->state_list as $state)
        {
            self::where('state_id',(int)$state['state_id'])->where('item_id',$request->item_id)->delete();
            $data         = self::create([
                'item_id'         => $request->item_id,
                'state_id'        => (int)$state['state_id'],
                'delivery_charge' => $state['delivery_charge']
            ]);
        }
        return $data;
    }

    public function getProductDeliveryChargeList($request)
    {
        $query =  self::with('state')->where('item_id',$request->id)->where('deleted_at',NULL);
        return $query->paginate($request->limit);
    }
 
    public function updateProductDeliveryCharge($request)
    {
        $data = [

            'state_id'        => $request->state_id,
            'delivery_charge' => $request->delivery_charge
        ];

        return self::where('id',$request->id)->update($data);
      
    }

    public function deleteProductDeliveryCharge($id)
    {
        return self::where('id',$id)->forceDelete();
    }

    public function delItemState($item_id,$state_id)
    {
        return self::where('item_id',$item_id)->where('state_id',$state_id)->delete();
    }

    public function checkDelivery($item_id,$state_id)
    {
        return self::where('item_id',$item_id)->where('state_id',$state_id)->first();
    }

    public function getDeliveryChargeByaddress($state_id,$item_id)
    {
        $amount     = 0;
        $charge     = self::where('item_id',$item_id)->where('state_id',$state_id)->first();
        if($charge)
        {
            $amount     = $charge->delivery_charge;
        }
        return $amount;
    }
}
