<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
class PushNotification extends Model
{

    use SoftDeletes;


    protected $fillable = [
        'title',
		'description',
        'image'

    ];

    protected $hidden = [
        'created_at','updated_at'
    ];


    public function store()
    {
        return $this->belongsTo('App\Store');
    }

    public function service_location()
    {
        return $this->belongsTo('App\Models\ServiceLocation');
    }

    public function createPushNotifications($input)
    {
        return self::create($input);
    }

    public function updatePushNotifications($id,$input)
    {
       return self::where('id',$id)->update($input);
    }

    public function getPushNotificationLists($request)
    {
        $query =  self::where('deleted_at',null)->orderBy('id','desc');
        if( isset($request->search) && !empty($request->search))
        {
            $query = $query->where("title",'LIKE','%'.$request->search.'%');
        }
        return $query->paginate($request->limit);
    }
}