<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
class PushNotificationUser extends Model
{
    use SoftDeletes;

  
    protected $fillable = [
        
        'user_id',
        'notification_id',
    ];

    public function user()
    {
        return $this->belongsTo('App\Models\User');
    }

    public function createData($user_id,$notification_id)
    {
        return self::create([
            'user_id'           =>  $user_id,
            'notification_id'   =>  $notification_id
        ]);
    }

    public function getNotifcationUsers($id)
    {
        return self::where('notification_id',$id)
                    ->with('user:id,name,phone')
                    ->get();
    }
}
