<?php

namespace App\Models;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Model;

class Reseller extends Model
{
    use SoftDeletes;
    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'name',
        'address',
        'user_id',
        'is_active',
        'phone',
        'pincode',
        'whatsapp_no',
        'email',
        'account_name',
        'account_number',
        'ifsc',
        'upi_id',
        'bank_name',
        'branch_name'
    ];

    /**
     * The attributes excluded from the model's JSON form.
     *
     * @var array
     */
    protected $hidden = [
        'created_at','updated_at','deleted_at'
    ];

    /**
    * 
    * @return void
    */

    public function user()
    {
        return $this->belongsTo('App\Models\User');
    }
    
    public function createReseller($request, $user_id)
    {

        $data    = [
            'phone'              => $request->phone,
            'whatsapp_no'        => $request->whatsapp_no,
            'name'               => $request->name,
            'email'              => $request->email,
            'address'            => $request->address,
            'pincode'            => $request->pincode,
            'user_id'            => $user_id,
            'is_active'          => $request->is_active,
            'account_name'       => $request->account_name,
            'account_number'     => $request->account_number,
            'bank_name'          => $request->bank_name,
            'branch_name'        => $request->branch_name,
            'ifsc'               => $request->ifsc,
            'upi_id'             => $request->upi_id
        ];
      
        return self::create($data);
    }

    /**
     * 
     * 
     * 
     */
    public function getResellerList($request)
    {
        $query =  self::where('deleted_at',null);
        if( isset($request->search) && !empty($request->search))
        {
            $query = $query->where("name",'LIKE','%'.$request->search.'%');
        }
        return $query->paginate($request->limit);
    }
    
    /**
     * 
     * 
     * 
     */
    public function delReseller($id)
    {
        return self::where('id',$id)->delete();
        
    }

    /**
     * 
     * 
     * 
     */
    public function getResellerById($id)
    {
        return self::where('id',$id)->first();
    }

    /**
     * 
     * 
     * 
     */
    public function getResellerByUserId($id)
    {
        return self::where('user_id',$id)
                    ->with('user:id,phone,firebase_token')
                    ->first();
    }

    /**
     * 
     * 
     */
    public function getSingleReseller($id)
    {
        return self::find($id);
    }

    public function updateReseller($request,$id)
    {
       
        $data    = [
            'phone'              => $request->phone,
            'whatsapp_no'        => $request->whatsapp_no,
            'name'               => $request->name,
            'email'              => $request->email,
            'address'            => $request->address,
            'pincode'            => $request->pincode,
            'is_active'          => $request->is_active,
            'account_name'       => $request->account_name,
            'account_number'     => $request->account_number,
            'bank_name'          => $request->bank_name,
            'branch_name'        => $request->branch_name,
            'ifsc'               => $request->ifsc,
            'upi_id'             => $request->upi_id,
        ];
        return self::where('id',$id)->update($data);
    }
    
    public function getResellers()
    {
        return self::get();
    }

    public function changeStatus($id)
    {
        $reseller =  self::where('id',$id)->first();
        if($reseller->is_active == 1)
        {
            return self::where('id',$id)->update(['is_active' => 0]);
        }
        else
        {
            return self::where('id',$id)->update(['is_active' => 1]);
        }
    }

    /**
    * 
    * @return void
    */

    public function createNewReseller($request, $user_id)
    {

        $data    = [
            'user_id'            => $user_id,
            'name'               => $request->name,
            'phone'              => $request->phone,
            'email'              => $request->email,
            'pincode'            => $request->pincode,
            'is_active'          => 1
        ];
      
        return self::create($data);
    }
    /**
     * 
     * 
     */
    public function getBankDetails($reseller_id)
    {
        return self::select(
            'account_name',
            'account_number',
            'ifsc',
            'upi_id',
            'bank_name',
            'branch_name'
        )
        ->where('id',$reseller_id)
        ->first();
    }

    /**
     * 
     * 
     */
    public function updateResellerProfile($request)
    {
        return self::where('id',$request->reseller_id)->update([
            "name"          => $request->name,
            "address"       => $request->address,
            "phone"         => $request->phone,
            "email"         => $request->email
        ]);
    }
}
