<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ResellerAccount extends Model
{
    use SoftDeletes;
    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'reseller_id',
        'is_active',
        'account_name',
        'account_number',
        'ifsc',
        'upi_id',
        'bank_name',
        'branch_name',
        'is_default'
    ];

    /**
     * The attributes excluded from the model's JSON form.
     *
     * @var array
     */
    protected $hidden = [
        'created_at','updated_at','deleted_at'
    ];

    /**
    * 
    * @return void
    */

    public function createNewResellerAccount($request,$reseller_id)
    {

        $data    = [
            'reseller_id'        => $reseller_id,
            'account_name'       => $request->account_name,
            'account_number'     => $request->account_number,
            'bank_name'          => $request->bank_name,
            'branch_name'        => $request->branch_name,
            'ifsc'               => $request->ifsc,
            'upi_id'             => $request->upi_id,
            'is_default'         => 1
        ];
      
        return self::create($data);
    }

    public function createResellerAccount($request,$is_default)
    {

        $data    = [
            'reseller_id'        => $request->reseller_id,
            'account_name'       => $request->account_name,
            'account_number'     => $request->account_number,
            'bank_name'          => $request->bank_name,
            'branch_name'        => $request->branch_name,
            'ifsc'               => $request->ifsc,
            'upi_id'             => $request->upi_id,
            'is_default'         => $is_default
        ];
      
        return self::create($data);
    }

    /**
     * 
     * 
     * 
     */
    public function getResellerAccountList($request)
    {
        $query =  self::where('deleted_at',null);
        if( isset($request->search) && !empty($request->search))
        {
            $query = $query->where("account_name",'LIKE','%'.$request->search.'%');
        }
        return $query->paginate($request->limit);
    }
    
    /**
     * 
     * 
     * 
     */
    public function delResellerAccount($id)
    {
        return self::where('id',$id)->delete();
        
    }

    /**
     * 
     * 
     * 
     */
    public function getResellerAccountById($id)
    {
        return self::where('id',$id)->first();
    }

    /**
     * 
     * 
     */
    public function getSingleResellerAccount($id)
    {
        return self::find($id);
    }

    public function updateResellerAccount($request)
    {
       
        $data    = [
            'account_name'       => $request->account_name,
            'account_number'     => $request->account_number,
            'bank_name'          => $request->bank_name,
            'branch_name'        => $request->branch_name,
            'ifsc'               => $request->ifsc,
            'upi_id'             => $request->upi_id
        ];
        return self::where('id',$request->account_id)->update($data);
    }
    
    public function getResellerAccountss()
    {
        return self::get();
    }

    public function changeStatus($id)
    {
        $account =  self::where('id',$id)->first();
        if($account->is_active == 1)
        {
            return self::where('id',$id)->update(['is_active' => 0]);
        }
        else
        {
            return self::where('id',$id)->update(['is_active' => 1]);
        }
    }

    public function setDefualtAccount($id)
    {
        $account =  self::where('is_default',1)->first();
        $account->is_default = 0;
        $account->save();

        return self::where('id',$id)->update(['is_default' => 1]);
    }

    /**
    * 
    * @return void
    */
    public function getBankDetails($reseller_id)
    {
        return self::select(
            'id',
            'reseller_id',
            'account_name',
            'account_number',
            'ifsc',
            'upi_id',
            'bank_name',
            'branch_name',
            'is_active',
            'is_default'
        )
        ->where('reseller_id',$reseller_id)
        ->get();
    }

    public function getDefaultAccount($reseller_id)
    {
        return self::where('reseller_id',$reseller_id)->where('is_default',1)->first();
    }
}
