<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Carbon\Carbon;
class Review extends Model
{
    use SoftDeletes;

    protected $table='reviews';

    protected $fillable = [
   
        'item_id',
        'reseller_id',
        'rating',
        'review',
        'image'
    ];

    /**
    * 
    * @return void
    */
    public function reseller()
    {
        return $this->belongsTo('App\Models\Reseller','reseller_id','id');
    }

    /**
    * 
    * @return void
    */
    public function item()
    {
        return $this->belongsTo('App\Models\Item','item_id','id');
    }

    public function getReviewById($id)
    {
        return self::with('reseller')->find($id);
    }

    /**
    *
    *
    */
    public function createReview($input)
    {
        return self::create($input);
    }

    public function updateReview($request,$id)
    {
        $data = [ 
            
            'rating'                 => $request->rating,
            'review'                 => $request->review,
            
        ];
        return self::where('id',$id)->update($data); 
   
    }

    public function getReviewList($request)
    {
           
        $query =  self::with('item','reseller')->where('item_id',$request->id)->where('deleted_at',NULL);
        if( isset($request->search) && !empty($request->search))
        {
            $query = $query->where("rating",'LIKE','%'.$request->search.'%');
        }
        return $query->paginate($request->limit);
    }

    public function getReviews($request)
    {
           
        $query =  self::with('item','reseller')->where('reseller_id',$request->reseller_id)->where('deleted_at',NULL);
        if( isset($request->search) && !empty($request->search))
        {
            $query = $query->where("rating",'LIKE','%'.$request->search.'%');
        }
        return $query->paginate($request->limit);
    }
  
    
    public function deleteReview($id)
    {
        return self::where('id',$id)->delete();
    }


    /**
     * 
     * 
     */
    public function getProductReviewTotalPages($product_id,$limit)
    {
        $result    =  self::where('item_id',$product_id)
        ->orderBy('id','desc')
        ->paginate(($limit) ? $limit :12);
        $total_page = (int)ceil($result->total()/$result->perPage());
        return $total_page;
    }

    /**
     * 
     * 
     */
    public function getReviewsListByProducts($product_id,$limit,$offset)
    {
        return  self::with('item','reseller')
        ->where('item_id',$product_id)
        ->offset(($offset) ? $offset :0)
        ->limit(($limit) ? $limit :12)
        ->get();
    }

}
