<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Support\Facades\DB;

class Settings extends Model
{
    use SoftDeletes;

    /**
     * fillable columns
     *
     * @var array
     */
    protected $fillable = [
        'key',
        'value',
        'input_type'
    ];

    /**
     * The attributes excluded from the model's JSON form.
     *
     * @var array
     */
    protected $hidden = [
        'created_at', 'updated_at', 'deleted_at'
    ];

    /**
     * 
     * 
     */
    public function getSettings($key = null)
    {
        $result = null;
        if($key != null)
        {
            $settings   = self::where('key', $key)->where('deleted_at', NULL)->get()->first();
            if ($settings != null) 
            {
                $settings   = $settings->toArray();
                $result     = $settings['value'];
            }
        }
        return $result;
    }

     /**
     * 
     * 
     */
    public function getAllSettings()
    {
       return self::get()
       ->pluck('value','key');
    }

    /**
     * 
     * 
     */
    public function deleteSettings($id)
    {
       return self::where('id', $id)->delete();
    }

    /**
     * 
     * 
     */
    public function getSettingsById($id)
    {
       return self::where('id', $id)->first();
    }

    /**
     * 
     * 
     */
    public function updateSettings($request)
    {
       return self::where('id', $request->id)
            ->update([ 'key' => $request->key, 'value' => $request->value  ]);
    }

    /**
     * 
     * 
     */
    public function createSettings($request)
    {
       return self::create([ 'key' => $request->key, 'value' => $request->value  ]);
    }

    

     /**
     * 
     * 
     */
    public function getSettingList($request)
    {
         $query = self::where('deleted_at',NULL);
       
        if( $request->search != '' )
        {
            $query = $query->where('key','LIKE','%'. $request->search .'%');
            $query = $query->orWhere('value','LIKE','%'. $request->search .'%');
           
        }        
        return $query->paginate($request->limit); 
    }

    public function getAppVersion($settings_key)
    {
       return self::where('key', $settings_key)
       ->first();
    }

}

