<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class SharedAds extends Model
{
    //
    use SoftDeletes;

    const CREATED_AT = 'created_at';
    const UPDATED_AT = 'updated_at';

    /**
     * fillable colums
     *
     * @var array
     */
    protected $fillable = [
        'reseller_id',
        'item_id',
        'platform'
    ];
    /**
     * The attributes excluded from the model's JSON form.
     *
     * @var array
     */
    protected $hidden = [
        'deleted_at','created_at','updated_at'
    ];
   
    /**
    * 
    * @return void
    */
    public function reseller()
    {
        return $this->belongsTo('App\Models\Reseller','reseller_id','id');
    }

        /**
    * 
    * @return void
    */
    public function product()
    {
        return $this->belongsTo('App\Models\Item','item_id','id')->with('gallery');
    }


   
    /**
     * add products to user wishlist
     * @author  Rahul
     * 
     */
    public function createSharedAds($input)
    {
        return self::create($input);
    }
     /**
     * 
     * 
     */
    public function getSharedAds($reseller_id)
    {
         return self::with('product')
            ->where('reseller_id', $reseller_id)
            ->limit(30)
            ->select(
            'id',
            'reseller_id',
            'item_id',
            'platform')
            ->get();
    }

    /**
     * 
     */
    public function deleteSharedAds($shared_ad_id)
    {
        return self::where('id',$shared_ad_id)->delete();
    }

}
