<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Slider extends Model
{
    use SoftDeletes;
    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'title','description','image'
    ];


    /**
     * @author Soorya
     */
    public function createSlider($input)
    {
       return self::create($input);
    }
    /**
     * @author Soorya
     */
    public function updateSlider($id,$input)
    {
       return self::where('id',$id)->update($input);
    }
    /**
     * @author Soorya
     */
    public function deleteSlider($id)
    {
        return self::where('id',$id)->delete();
    }
    /**
     * @author Soorya
     */
    public function getSingleSlider($id)
    {
        return self::where('id',$id)->first();
    }
    /**
     * @author Soorya
     */
    public function getAdminSliderList($request)
    {
        $query =  self::where('deleted_at',NULL);
        if( isset($request->search) && !empty($request->search))
        {
            $query = $query->where("name",'LIKE','%'.$request->search.'%');
        }
        return $query->paginate($request->limit);
    }
}
