<?php

namespace App\Models;

use Illuminate\Notifications\Notifiable;
use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Support\Str;
use Laravel\Passport\HasApiTokens;
use Illuminate\Support\Carbon;
   
     
class User extends Authenticatable
{
    use HasApiTokens,Notifiable;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'name',
        'email',
        'phone',
        'password',
        'uid',
        'otp',
        'role_id',
        'address',
        'opt_updated_at',
        'otp_verified',
        'profile_picture',
        'latitude',
        'longitude',
        'is_active',
        'firebase_token',
        'is_vendor',
        'is_reseller',
        'google_id'
    ];
    
     /**
     *  Setup model event hooks
     */
     public static function boot()
     {
         parent::boot();
         self::creating(function ($model) {
             $model->uid = (string) Str::uuid();
             
         });
    }
    

    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = [
        'password', 'remember_token',
    ];

    /**
     * The attributes that should be cast to native types.
     *
     * @var array
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
    ];

    /**
     * 
     */
    public function getProfilePictureAttribute($value)
    {
        if($value == null)
        {
            $value = "";
        }
        return $value;
    }
    /**
     * to create a user
     * @author  RAHUL
     * 
     */

    public function service_location()
    {
        return $this->belongsTo('App\Models\ServiceLocation');
    }


    public function users()
    {
         return $this->belongsToMany('App/Models/User');
    }
    
    public function reseller()
    {
        return $this->hasOne('App\Models\Reseller');
    }

    public function vendor()
    {
        return $this->hasOne('App\Models\Vendor');
    }
    
    
    public function createUser($request)
    {
        return self::create([
            'name'         => trim( ucfirst($request->name)     ),
            'email'        => trim( $request->email ),
            'phone'        => trim( $request->phone ),
            'password'     => $request->password,
            'is_active'    => 1,
            'role_id'      => 3,
            'is_reseller'  => Carbon::now()->format('Y-m-d H:i:s')
        ]);
    }

    //

    public function createTempUser($otp, $opt_updated_at, $phone)
    {
        return self::create([
            'otp'            => $otp,
            'opt_updated_at' => $opt_updated_at,
            'phone'          => $phone,
            'role_id'        => 1
        ]);
    }

    public function updateTempUser($request, $id)
    {
        return self::where('id',$id)
                    ->update([
            'name'          => $request->name,
            'email'         => $request->email,
            'password'      => $request->password,
            'address'       => $request->address
        ]);
    }

    public function createNewUser($data)
    {
        return self::create($data); 
    }
    public function createNewUserVendor($request, $id)
    {
        $data    = [
            'name'          => trim( ucfirst($request->name)),
            'address'       => trim( $request->address),
            'is_active'     => $request->is_active,
            'email'         => trim( $request->email),
            'phone'         => trim( $request->phone),
            'is_vendor'     => Carbon::now()->format('Y-m-d H:i:s')
        ];
        return self::where('id',$id)->update($data);
    }

    public function createNewUserReseller($request, $id)
    {
        $data    = [
            'name'          => trim( ucfirst($request->name)),
            'address'       => trim( $request->address),
            'is_active'     => $request->is_active,
            'email'         => trim( $request->email),
            'phone'         => trim( $request->phone),
            'is_reseller'   => Carbon::now()->format('Y-m-d H:i:s')
        ];
        return self::where('id',$id)->update($data);
    }


     /**
     * 
     * @author  RAHUL
     * 
     */
    public function updateUserWithId($input , $id )
    {
        return self::where('id',$id)->update($input);
    }

     /**
     * to get user by ID
     * @author  RAHUL
     * 
     */
    public function getUserById($id)
    {
        return self::where('id',$id)->first();
    }

    /**
     * 
     * 
     */
    public function getSingleUser($id)
    {
        return self::find($id);
    }

    public function updatePassword($id,$data)
    {
        return self::where('id',$id)->update($data);
    }

     /**
     * to get user by ID
     * @author  RAHUL
     * 
     */
    public function getUserByEmail($email)
    {
        return self::where('email',$email)->where("role_id",1)->first();
    }

    /**
     * 
     * @author SOORYA
     */
    public function getUserByPhoneOtp($phone)
    {
        return self::where('phone',$phone)
                    ->where("role_id",3)
                    ->first();
    }

    /**
     * to get user by ID
     * @author  RAHUL
     * 
     */
    public function getUserByPhone($phone)
    {
        return self::where('phone',$phone)->where("role_id",3)->where("otp_verified",1)->first();
    }

    public function getUserByEmailOrPhone($email)
    {
        return self::where('email',$email)->orWhere("phone",$email)->where("role_id",3)->first();
    }

    public function getUser($service_location_id)
    {
        return self::where('role_id',1)->where('service_location_id',$service_location_id)->get();           
    }

    public function getUserList($request)
    {
        $query =  self::where("is_vendor",'!=',null)->orWhere("is_reseller",'!=',null);
        if( isset($request->search) && !empty($request->search))
        {
            $query = $query->where("name",'LIKE','%'.$request->search.'%');
        }
        return $query->paginate($request->limit);
    }

    public function getUserByLocation($service_location_id)
    {
        return self::select('firebase_token')
        ->where('service_location_id',$service_location_id)
        ->where('role_id',1)
        ->where('is_active',1)
        ->get()->pluck('firebase_token')->toArray();
    }

    public function getUserByLocationId($service_location_id)
    {
        return self::where('service_location_id',$service_location_id)
        ->where('role_id',1)
        ->where('is_active',1)
        ->get();
    }

    /**
     * @author PMS
     */
    public function getUserByLocationForPush($service_location_id,$limit,$offset)
    {
        return self::select('firebase_token')
        ->where('service_location_id',$service_location_id)
        ->where('role_id',1)
        ->whereNotNull('name')
        ->limit($limit)
        ->offset($offset)
        ->get()->pluck('firebase_token')->toArray();
    }
   /**
    * 
    */
    public function getUserByLocationIdForPush($service_location_id,$limit,$offset)
    {
        return self::where('service_location_id',$service_location_id)
        ->where('role_id',1)
        ->whereNotNull('name')
        ->limit($limit)
        ->offset($offset)
        ->get();
    }
    /**
     * 
     * 
     */
    public function getServiceLocationsUsersCount($service_location_id)
    {
        return self::where('service_location_id',$service_location_id)
        ->where('role_id',1)
        ->where('is_active',1)
        ->get()->count();
    }

    public function getReseller($request)
    {
        return self::with('reseller')->where('id',$request->user)->first();
    }

    public function getVendor($request)
    {
        return self::with('vendor')->where('id',$request->user)->first();
    }

    /**
     * 
     * 
     */
    public function updateUserProfile($request)
    {
        return self::where('id',$request->user_id)->update([
            "name"              => $request->name,
            "address"           => $request->address,
            "phone"             => $request->phone,
            "email"             => $request->email,
            "profile_picture"   => $request->logo

        ]);
    }

    /**
     * 
     * 
     */
    public function getUsersCount()
    {
        return self::where('role_id',3)
        ->where('is_active',1)
        ->get()->count();
    }

    /**
     * @author PMS
     */
    public function getUserForPush($limit,$offset)
    {
        return self::select('firebase_token')
        ->where('role_id',3)
        ->whereNotNull('name')
        ->limit($limit)
        ->offset($offset)
        ->get();
    }

    public function getUserForPushUserIds($limit,$offset)
    {
        return self::select('id')
        ->where('role_id',3)
        ->whereNotNull('name')
        ->limit($limit)
        ->offset($offset)
        ->get()->pluck('id')->toArray();
    }
    

    /**
    * 
    */
    public function getUserIdForPush($limit,$offset)
    {
        return self::where('role_id',3)
        ->whereNotNull('name')
        ->limit($limit)
        ->offset($offset)
        ->get();
    }
}
