<?php

namespace App\Models;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Model;

class UserAddress extends Model
{
    use SoftDeletes;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'user_id',
        'contact_name',
        'house_name',
        'landmark',
        'state_id',
        'city',
        'mobile_number',
        'email',
        'pincode',
        'is_primary'
    ];

    /**
     * The attributes excluded from the model's JSON form.
     *
     * @var array
     */
    protected $hidden = [
        'created_at','updated_at','deleted_at'
    ];


    public function reseller()
    {
        return $this->belongsTo('App\Models\Reseller');
    }

    public function state()
    {
        return $this->belongsTo('App\Models\State');
    }


    /**
    *
    *
    */
    public function getUserAddressById($id)
    {
         return self::where('id',$id)->first();
    }

    /**
    *
    *
    */
    public function createAddress($input)
    {
        return self::create($input);
    }

    /**
    *
    *
    */
    public function updateAddress($id, $input)
    {
        return self::where('id',$id)->update($input);
    }
    /**
     * 
     */
    public function getDefaultAddress($user_id)
    {
        return self::where('user_id',$user_id)->where('is_primary',1)->first();
    }
    

     /**
    *
    *
    */
    public function deleteAddress($id)
    {
        return self::where('id',$id)->delete();
    }

    public function getUserAddress($reseller_id)
    {
        return self::select('id','contact_name','house_name','landmark','state_id','city','mobile_number','pincode')
        ->with('state')
        ->where('reseller_id',$reseller_id)
        ->orderBy('id','desc')
        ->get();
    }

    public function getUserAddressList($request)
    {
        $query =  self::with('reseller')->where('reseller_id',$request->id)->where('deleted_at',NULL);
        return $query->paginate($request->limit);
    }
 
    public function setDefualtAddress($id)
    {
        $address =  self::where('is_primary',1)->first();
        $address->is_primary = 0;
        $address->save();

        return self::where('id',$id)->update(['is_primary' => 1]);
    }
}
