<?php

namespace App\Models;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Model;

class UserDevice extends Model
{
    use SoftDeletes;
    protected $fillable = [
        'user_id',
        'firebase_token',
        'device_id',
        'device_type'
    ];

    public function createUserDevice($input)
    {
        $exisiting_device_id    = self::where('user_id',$input['user_id'])->where('device_id',$input['device_id'])->first();
        if($exisiting_device_id)
        {
            return self::where('id',$exisiting_device_id->id)->update(['firebase_token'=>$input['firebase_token']]);
        }
        else
        {
            self::where('device_id',$input['device_id'])->delete();
            return self::create($input);
        }
    }

    public function userFirebaseTokenList($user_id)
    {
        return self::where('user_id',$user_id)->pluck('firebase_token')->toArray();
    }

    public function userFirebaseTokenListByUserIds($user_ids)
    {
        return self::whereIn('user_id',$user_ids)->pluck('firebase_token')->toArray();
    }
}
