<?php

namespace App\Models;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Model;

class UserLogHistory extends Model
{
    use SoftDeletes;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'user_id',
        'device_id',
        'firebase_token',
        'os',
    ];

     /**
     * The attributes excluded from the model's JSON form.
     *
     * @var array
     */
    protected $hidden = [
        'updated_at','deleted_at'
    ];

    public function getCreatedAtAttribute($value)
    {
         return date("d/m/Y");
    }

      /**
     * to create a user
     * @author  RAHUL
     * 
     */
    public function createUserLog($input)
    {
        return self::create($input);
    }
}
